/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.teamabnormals.blueprint.client.renderer.SlabfishHatRenderLayer;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.BlueprintConfig;
import com.teamabnormals.blueprint.core.sonar.OnlineRequest;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="blueprint", value={Dist.CLIENT})
public final class RewardHandler {
    public static final Map<UUID, RewardData> REWARDS = new HashMap<UUID, RewardData>();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final String REWARDS_URL = "https://api.minecraftabnormals.com/rewards.json";
    private static final ResourceLocation CAPE_TEXTURE = new ResourceLocation("blueprint", "textures/abnormals_cape.png");
    private static RewardProperties rewardProperties;

    public static void clientSetup(FMLClientSetupEvent event) {
        OnlineRequest.request(REWARDS_URL, Util.m_183991_()).thenAcceptAsync(stream -> {
            if (stream == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)stream);){
                JsonObject object = GsonHelper.m_13859_((Reader)reader);
                for (Map.Entry entry : object.entrySet()) {
                    if (((String)entry.getKey()).equals("properties")) {
                        rewardProperties = (RewardProperties)GSON.fromJson((JsonElement)entry.getValue(), RewardProperties.class);
                        continue;
                    }
                    REWARDS.put(UUID.fromString((String)entry.getKey()), (RewardData)GSON.fromJson((JsonElement)entry.getValue(), RewardData.class));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse rewards.", (Throwable)e);
            }
        }, (Executor)Minecraft.m_91087_());
    }

    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        event.getSkins().forEach(skin -> {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skin);
            renderer.m_115326_((RenderLayer)new SlabfishHatRenderLayer(renderer));
        });
    }

    @Nullable
    public static RewardProperties getRewardProperties() {
        return rewardProperties;
    }

    @SubscribeEvent
    public static void onEvent(RenderPlayerEvent.Post event) {
        AbstractClientPlayer clientPlayer;
        Player player = event.getPlayer();
        UUID uuid = Player.m_36198_((GameProfile)player.m_36316_());
        if (REWARDS.containsKey(uuid) && REWARDS.get(uuid).getTier() >= 99 && (clientPlayer = (AbstractClientPlayer)player).m_108555_() && clientPlayer.m_108561_() == null) {
            Map playerTextures = clientPlayer.f_108546_.f_105299_;
            playerTextures.put(MinecraftProfileTexture.Type.CAPE, CAPE_TEXTURE);
            playerTextures.put(MinecraftProfileTexture.Type.ELYTRA, CAPE_TEXTURE);
        }
    }

    @SubscribeEvent
    public static void onEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
        NetworkUtil.updateSlabfish(SlabfishSetting.getConfig());
    }

    public static final class RewardProperties {
        private final SlabfishProperties slabfish;

        public RewardProperties(SlabfishProperties slabfish) {
            this.slabfish = slabfish;
        }

        public SlabfishProperties getSlabfishProperties() {
            return this.slabfish;
        }

        public static final class SlabfishProperties {
            private final String defaultTypeUrl;
            private final String typeUrl;
            private final String sweaterUrl;
            private final String backpackUrl;

            public SlabfishProperties(String defaultTypeUrl, String typeUrl, String sweaterUrl, String backpackUrl) {
                this.defaultTypeUrl = defaultTypeUrl;
                this.typeUrl = typeUrl;
                this.sweaterUrl = sweaterUrl;
                this.backpackUrl = backpackUrl;
            }

            public String getDefaultTypeUrl() {
                return this.defaultTypeUrl;
            }

            public String getTypeUrl() {
                return this.typeUrl;
            }

            public String getSweaterUrl() {
                return this.sweaterUrl;
            }

            public String getBackpackUrl() {
                return this.backpackUrl;
            }
        }
    }

    public static final class RewardData {
        private final String username;
        private final int tier;
        private final SlabfishData slabfish;

        public RewardData(String username, int tier, SlabfishData slabfish) {
            this.username = username;
            this.tier = tier;
            this.slabfish = slabfish;
        }

        public String getUsername() {
            return this.username;
        }

        public int getTier() {
            return this.tier;
        }

        public SlabfishData getSlabfish() {
            return this.slabfish;
        }

        public static final class SlabfishData {
            private final boolean translucent;
            @SerializedName(value="type")
            private final String typeUrl;
            @SerializedName(value="sweater")
            private final String sweaterUrl;
            @SerializedName(value="backpack")
            private final String backpackUrl;
            private String typeUrlCache;
            private String sweaterUrlCache;
            private String backpackUrlCache;

            public SlabfishData(boolean translucent, String typeUrl, String sweaterUrl, String backpackUrl) {
                this.translucent = translucent;
                this.typeUrl = typeUrl;
                this.sweaterUrl = sweaterUrl;
                this.backpackUrl = backpackUrl;
            }

            public boolean isTranslucent() {
                return this.translucent;
            }

            public String getTypeUrl() {
                return this.typeUrlCache == null ? (this.typeUrlCache = SlabfishData.resolveUrl(RewardProperties.SlabfishProperties::getTypeUrl, () -> this.typeUrl)) : this.typeUrlCache;
            }

            public String getSweaterUrl() {
                return this.sweaterUrlCache == null ? (this.sweaterUrlCache = SlabfishData.resolveUrl(RewardProperties.SlabfishProperties::getSweaterUrl, () -> this.sweaterUrl)) : this.sweaterUrlCache;
            }

            public String getBackpackUrl() {
                return this.backpackUrlCache == null ? (this.backpackUrlCache = SlabfishData.resolveUrl(RewardProperties.SlabfishProperties::getBackpackUrl, () -> this.backpackUrl)) : this.backpackUrlCache;
            }

            private static String resolveUrl(Function<RewardProperties.SlabfishProperties, String> baseUrl, Supplier<String> url) {
                String appliedUrl = baseUrl.apply(rewardProperties.getSlabfishProperties());
                if (url.get() == null) {
                    return null;
                }
                if (appliedUrl == null || url.get().startsWith("http")) {
                    return url.get();
                }
                return String.format(appliedUrl, url.get());
            }
        }
    }

    public static enum SlabfishSetting {
        ENABLED(() -> BlueprintConfig.CLIENT.slabfishSettings.enabled),
        SWEATER(() -> BlueprintConfig.CLIENT.slabfishSettings.sweaterEnabled),
        BACKPACK(() -> BlueprintConfig.CLIENT.slabfishSettings.backpackEnabled),
        TYPE(() -> BlueprintConfig.CLIENT.slabfishSettings.typeEnabled);

        private final Supplier<ForgeConfigSpec.ConfigValue<Boolean>> configValue;

        private SlabfishSetting(Supplier<ForgeConfigSpec.ConfigValue<Boolean>> configValue) {
            this.configValue = configValue;
        }

        public ForgeConfigSpec.ConfigValue<Boolean> getConfigValue() {
            return this.configValue.get();
        }

        public static byte getConfig() {
            int value = 0;
            for (SlabfishSetting setting : SlabfishSetting.values()) {
                if (!((Boolean)setting.getConfigValue().get()).booleanValue()) continue;
                value |= 1 << setting.ordinal();
            }
            return (byte)value;
        }

        public static boolean getSetting(IDataManager data, SlabfishSetting flag) {
            return (data.getValue(Blueprint.SLABFISH_SETTINGS) >> flag.ordinal() & 1) > 0;
        }
    }
}

