/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSource;
import com.teamabnormals.blueprint.common.world.modification.ModdedSurfaceSystem;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.BlueprintConfig;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blueprint")
public final class ModdedBiomeSlicesManager
extends SimpleJsonResourceReloadListener {
    private static ModdedBiomeSlicesManager INSTANCE;
    private final List<Pair<ConditionedResourceSelector, ModdedBiomeSlice>> unassignedSlices = new LinkedList<Pair<ConditionedResourceSelector, ModdedBiomeSlice>>();
    private final RegistryOps<JsonElement> registryOps;

    public ModdedBiomeSlicesManager(RegistryOps<JsonElement> registryOps) {
        super(new Gson(), "modded_biome_slices");
        this.registryOps = registryOps;
    }

    @SubscribeEvent
    public static void onReloadListener(AddReloadListenerEvent event) {
        try {
            INSTANCE = new ModdedBiomeSlicesManager(DataUtil.createRegistryOps(event.getServerResources()));
            event.addListener((PreparableReloadListener)INSTANCE);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void onServerAboutToStart(MinecraftServer server) {
        if (INSTANCE == null) {
            return;
        }
        List<Pair<ConditionedResourceSelector, ModdedBiomeSlice>> unassignedSlices = ModdedBiomeSlicesManager.INSTANCE.unassignedSlices;
        if (unassignedSlices.isEmpty()) {
            return;
        }
        WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
        Registry dimensions = worldGenSettings.m_204655_();
        Set keySet = dimensions.m_6566_();
        HashMap assignedSlices = new HashMap();
        for (Pair<ConditionedResourceSelector, ModdedBiomeSlice> unassignedSlice : unassignedSlices) {
            ModdedBiomeSlice slice = (ModdedBiomeSlice)unassignedSlice.getSecond();
            if (slice.weight() <= 0) {
                return;
            }
            ((ConditionedResourceSelector)unassignedSlice.getFirst()).select(keySet::forEach).forEach(location -> assignedSlices.computeIfAbsent(location, __ -> new ArrayList()).add(slice));
        }
        CommentedConfig moddedBiomeSliceSizes = (CommentedConfig)BlueprintConfig.COMMON.moddedBiomeSliceSizes.get();
        int defaultSize = moddedBiomeSliceSizes.getIntOrElse("default", 9);
        if (defaultSize <= 0) {
            Blueprint.LOGGER.warn("Found a non-positive value for the default slice size! Slice size 9 will be used instead.");
            defaultSize = 9;
        }
        Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
        long seed = worldGenSettings.m_64619_();
        for (Map.Entry entry : dimensions.m_6579_()) {
            ChunkGenerator chunkGenerator;
            BiomeSource source;
            ResourceLocation location2 = ((ResourceKey)entry.getKey()).m_135782_();
            ArrayList slicesForKey = (ArrayList)assignedSlices.get(location2);
            if (slicesForKey == null || slicesForKey.isEmpty() || (source = (chunkGenerator = ((LevelStem)entry.getValue()).m_63990_()).m_62218_()) instanceof FixedBiomeSource || source instanceof CheckerboardColumnBiomeSource) continue;
            int size = moddedBiomeSliceSizes.getIntOrElse(location2.toString(), defaultSize);
            if (size <= 0) {
                size = defaultSize;
            }
            ModdedBiomeSource moddedBiomeSource = new ModdedBiomeSource((Registry<Biome>)biomeRegistry, source, slicesForKey, size, seed, location2.hashCode());
            moddedBiomeSource.f_186695_ = Suppliers.memoize(() -> moddedBiomeSource.m_186727_(List.copyOf(moddedBiomeSource.m_207840_()), true));
            chunkGenerator.f_62137_ = moddedBiomeSource;
            chunkGenerator.f_62138_ = moddedBiomeSource;
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            ((ModdedSurfaceSystem)((NoiseBasedChunkGenerator)chunkGenerator).f_188605_).setModdedBiomeSource(moddedBiomeSource);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        List<Pair<ConditionedResourceSelector, ModdedBiomeSlice>> unassignedSlices = this.unassignedSlices;
        unassignedSlices.clear();
        RegistryOps<JsonElement> registryOps = this.registryOps;
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation name = entry.getKey();
            try {
                unassignedSlices.add(ModdedBiomeSlice.deserializeWithSelector(name, entry.getValue(), registryOps));
            }
            catch (JsonParseException exception) {
                Blueprint.LOGGER.error("Parsing error loading Modded Biome Slice: {}", (Object)name, (Object)exception);
            }
        }
        Blueprint.LOGGER.info("Modded Biome Slice Manager has loaded {} slices", (Object)unassignedSlices.size());
    }
}

