/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierGroup;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.eventbus.api.EventPriority;

public record StructureRepaletterEntry(ConditionedResourceSelector selector, EventPriority priority, StructureRepaletter repaletter) {
    @Nullable
    public static StructureRepaletterEntry deserialize(ResourceLocation name, JsonElement element, DynamicOps<JsonElement> ops) throws JsonParseException {
        JsonObject object = GsonHelper.m_13918_((JsonElement)element, (String)element.toString());
        ConditionedResourceSelector selector = ConditionedResourceSelector.deserialize("selector", object.get("selector"));
        if (selector == ConditionedResourceSelector.EMPTY) {
            Blueprint.LOGGER.info("Skipped structure repaletter named '" + name + "' as its conditions were not met");
            return null;
        }
        EventPriority priority = ObjectModifierGroup.deserializePriority(object);
        DataResult result = StructureRepaletter.CODEC.decode(ops, (Object)object);
        Optional error = result.error();
        if (error.isPresent()) {
            throw new JsonParseException(((DataResult.PartialResult)error.get()).message());
        }
        return new StructureRepaletterEntry(selector, priority, (StructureRepaletter)((Pair)result.result().get()).getFirst());
    }

    public JsonElement serialize(DynamicOps<JsonElement> ops) throws JsonParseException {
        JsonObject object = new JsonObject();
        object.add("selector", this.selector.serialize());
        object.addProperty("priority", this.priority.toString().toLowerCase(Locale.ROOT));
        DataResult result = StructureRepaletter.CODEC.encode((Object)this.repaletter, ops, (Object)object);
        Optional error = result.error();
        if (error.isPresent()) {
            throw new JsonParseException(((DataResult.PartialResult)error.get()).message());
        }
        return (JsonElement)result.get().left().get();
    }
}

