/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public final class EndimationLoader
implements PreparableReloadListener {
    private static final JsonParser PARSER = new JsonParser();
    private final BiMap<ResourceLocation, Endimation> registry = HashBiMap.create();

    @Nullable
    public Endimation getEndimation(ResourceLocation key) {
        return (Endimation)this.registry.get((Object)key);
    }

    @Nullable
    public ResourceLocation getKey(Endimation endimation) {
        return (ResourceLocation)this.registry.inverse().get((Object)endimation);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, ResourceManager manager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, Endimation> endimations = new HashMap<ResourceLocation, Endimation>();
            for (ResourceLocation resourcelocation : manager.m_6540_("endimations", file -> file.endsWith(".json"))) {
                try (InputStreamReader inputStreamReader = new InputStreamReader(manager.m_142591_(resourcelocation).m_6679_());){
                    DataResult dataResult = Endimation.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)PARSER.parse((Reader)inputStreamReader));
                    Optional error = dataResult.error();
                    if (error.isPresent()) {
                        throw new JsonParseException(((DataResult.PartialResult)error.get()).message());
                    }
                    String path = resourcelocation.m_135815_();
                    ResourceLocation adjustedLocation = new ResourceLocation(resourcelocation.m_135827_(), path.substring(12, path.length() - 5));
                    if (endimations.put(adjustedLocation, (Endimation)((Pair)dataResult.result().get()).getFirst()) == null) continue;
                    Blueprint.LOGGER.warn("Loaded Duplicate Endimation: {}", (Object)adjustedLocation);
                }
                catch (Exception exception) {
                    Blueprint.LOGGER.error("Error while loading Endimation: {}", (Object)resourcelocation, (Object)exception);
                }
            }
            return endimations;
        }, executor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0))).thenAcceptAsync(endimations -> {
            BiMap<ResourceLocation, Endimation> registry = this.registry;
            registry.clear();
            registry.putAll(endimations);
            registry.put((Object)PlayableEndimation.BLANK.location(), (Object)Endimation.BLANK);
            Blueprint.LOGGER.info("Endimation Loader has loaded {} endimations", (Object)registry.size());
        }, executor2);
    }
}

