/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockUtil {
    public static boolean isBlockInWater(Level level, BlockPos pos) {
        if (level.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!level.m_6425_(pos.m_142300_(direction)).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPlace(Level level, @Nullable Player player, BlockPos pos, BlockState state) {
        CollisionContext selectionContext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        VoxelShape voxelshape = state.m_60742_((BlockGetter)level, pos, selectionContext);
        VoxelShape offsetShape = level.m_8055_(pos).m_60812_((BlockGetter)level, pos);
        return (offsetShape.m_83281_() || level.m_8055_(pos).m_60767_().m_76336_()) && state.m_60710_((LevelReader)level, pos) && level.m_5450_(null, voxelshape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public static SoundEvent getPlaceSound(BlockState state, Level level, BlockPos pos, @Nullable Entity entity) {
        return state.getSoundType((LevelReader)level, pos, entity).m_56777_();
    }

    public static boolean isPosNotTouchingBlock(LevelAccessor level, BlockPos pos, Block blockToCheck, Direction ... blacklistedDirections) {
        for (Direction directions : Direction.values()) {
            List<Direction> blacklistedDirectionsList = Arrays.asList(blacklistedDirections);
            if (blacklistedDirectionsList.contains(directions) || level.m_8055_(pos.m_142300_(directions)).m_60734_() != blockToCheck) continue;
            return false;
        }
        return true;
    }

    public static BlockState transferAllBlockStates(BlockState initial, BlockState after) {
        BlockState block = after;
        for (Property property : initial.m_60734_().m_49965_().m_61092_()) {
            if (!after.m_61138_(property) || initial.m_61143_(property) == null) continue;
            block = (BlockState)block.m_61124_(property, initial.m_61143_(property));
        }
        return block;
    }

    public static AABB rotateHorizontalBB(AABB bb, BBRotation rotation) {
        return rotation.rotateBB(bb);
    }

    public static BlockPos offsetPos(BlockSource source) {
        return source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DirectionalBlock.f_52588_));
    }

    public static BlockState getStateAtOffsetPos(BlockSource source) {
        return source.m_7727_().m_8055_(BlockUtil.offsetPos(source));
    }

    public static <T extends Entity> List<T> getEntitiesAtOffsetPos(BlockSource source, Class<T> entityType) {
        return source.m_7727_().m_45976_(entityType, new AABB(BlockUtil.offsetPos(source)));
    }

    public static <T extends Entity> List<T> getEntitiesAtOffsetPos(BlockSource source, Class<T> entityType, Predicate<? super T> predicate) {
        return source.m_7727_().m_6443_(entityType, new AABB(BlockUtil.offsetPos(source)), predicate);
    }

    public static enum BBRotation {
        REVERSE_X(bb -> {
            float minX = 1.0f - (float)bb.f_82291_;
            return new AABB((double)minX, bb.f_82289_, bb.f_82290_, bb.f_82291_ >= 1.0 ? bb.f_82291_ - bb.f_82288_ : bb.f_82291_ + (double)minX, bb.f_82292_, bb.f_82293_);
        }),
        REVERSE_Z(bb -> {
            float minZ = 1.0f - (float)bb.f_82293_;
            return new AABB(bb.f_82288_, bb.f_82289_, (double)minZ, bb.f_82291_, bb.f_82292_, bb.f_82293_ >= 1.0 ? bb.f_82293_ - bb.f_82290_ : bb.f_82293_ + (double)minZ);
        }),
        RIGHT(bb -> new AABB(bb.f_82290_, bb.f_82289_, bb.f_82288_, bb.f_82293_, bb.f_82292_, bb.f_82291_)),
        LEFT(bb -> REVERSE_X.rotateBB(RIGHT.rotateBB((AABB)bb)));

        private final UnaryOperator<AABB> modifier;

        private BBRotation(UnaryOperator<AABB> modifier) {
            this.modifier = modifier;
        }

        public static BBRotation getRotationForDirection(Direction currentDirection, Direction startingDirection) {
            int currentIndex = currentDirection.m_122411_() - 2;
            int startingIndex = startingDirection.m_122411_() - 2;
            int index = (currentIndex - startingIndex) % 4;
            switch (index) {
                default: {
                    return REVERSE_X;
                }
                case 1: {
                    return REVERSE_Z;
                }
                case 2: {
                    return RIGHT;
                }
                case 3: 
            }
            return LEFT;
        }

        public AABB rotateBB(AABB bb) {
            return (AABB)this.modifier.apply(bb);
        }
    }
}

