/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicateSerializer;
import com.teamabnormals.blueprint.core.api.conditions.loot.ConfigLootCondition;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagManager;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class DataUtil {
    public static final Field TAG_MANAGER = ObfuscationReflectionHelper.findField(ReloadableServerResources.class, (String)"f_206849_");
    public static final Field REGISTRY_ACCESS = ObfuscationReflectionHelper.findField(TagManager.class, (String)"f_144569_");
    private static final Method ADD_MIX_METHOD = ObfuscationReflectionHelper.findMethod(PotionBrewing.class, (String)"m_43513_", (Class[])new Class[]{Potion.class, Item.class, Potion.class});
    private static final Vector<AlternativeDispenseBehavior> ALTERNATIVE_DISPENSE_BEHAVIORS = new Vector();
    private static final Vector<CustomNoteBlockInstrument> CUSTOM_NOTE_BLOCK_INSTRUMENTS = new Vector();

    public static void registerFlammable(Block block, int encouragement, int flammability) {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_(block, encouragement, flammability);
    }

    public static void registerCompostable(ItemLike item, float chance) {
        ComposterBlock.f_51914_.put((Object)item.m_5456_(), chance);
    }

    public static void addMix(Potion input, Item reactant, Potion result) {
        try {
            ADD_MIX_METHOD.invoke(null, input, reactant, result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to add mix for " + result.getRegistryName() + " from " + reactant.getRegistryName(), e);
        }
    }

    public static void registerBlockColor(BlockColors blockColors, BlockColor color, List<RegistryObject<Block>> blocksIn) {
        blocksIn.removeIf(block -> !block.isPresent());
        if (blocksIn.size() > 0) {
            Block[] blocks = new Block[blocksIn.size()];
            for (int i = 0; i < blocksIn.size(); ++i) {
                blocks[i] = (Block)blocksIn.get(i).get();
            }
            blockColors.m_92589_(color, blocks);
        }
    }

    public static void registerBlockItemColor(ItemColors itemColors, ItemColor color, List<RegistryObject<Block>> blocksIn) {
        blocksIn.removeIf(block -> !block.isPresent());
        if (blocksIn.size() > 0) {
            Block[] blocks = new Block[blocksIn.size()];
            for (int i = 0; i < blocksIn.size(); ++i) {
                blocks[i] = (Block)blocksIn.get(i).get();
            }
            itemColors.m_92689_(color, (ItemLike[])blocks);
        }
    }

    public static void registerVillagerGift(VillagerProfession profession) {
        ResourceLocation name = profession.getRegistryName();
        if (name != null) {
            GiveGiftToHero.f_147550_.put(profession, new ResourceLocation(name.m_135827_(), "gameplay/hero_of_the_village/" + name.m_135815_() + "_gift"));
        }
    }

    public static <T> T[] concatArrays(T[] array, T ... toAdd) {
        int arrayLength = array.length;
        int toAddLength = toAdd.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), arrayLength + toAddLength);
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        System.arraycopy(toAdd, 0, newArray, arrayLength, toAddLength);
        return newArray;
    }

    public static <T> void concatArrays(Field arrayField, @Nullable Object object, T ... toAdd) {
        try {
            arrayField.set(object, DataUtil.concatArrays((Object[])arrayField.get(object), toAdd));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void changeBlockLocalization(Block block, String modid, String name) {
        block.f_49787_ = Util.m_137492_((String)"block", (ResourceLocation)new ResourceLocation(modid, name));
    }

    public static void changeBlockLocalization(String inputMod, String input, String outputMod, String output) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(inputMod, input));
        if (block != null) {
            block.f_49787_ = Util.m_137492_((String)"block", (ResourceLocation)new ResourceLocation(outputMod, output));
        }
    }

    public static void changeItemLocalization(Item item, String modid, String name) {
        item.f_41379_ = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation(modid, name));
    }

    public static void changeItemLocalization(String inputMod, String input, String outputMod, String output) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputMod, input));
        if (item != null) {
            item.f_41379_ = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation(outputMod, output));
        }
    }

    public static boolean matchesKeys(ResourceLocation loc, ResourceKey<?> ... keys) {
        for (ResourceKey<?> key : keys) {
            if (!key.m_135782_().equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    public static void registerAlternativeDispenseBehavior(AlternativeDispenseBehavior behavior) {
        ALTERNATIVE_DISPENSE_BEHAVIORS.add(behavior);
    }

    public static void registerNoteBlockInstrument(CustomNoteBlockInstrument instrument) {
        CUSTOM_NOTE_BLOCK_INSTRUMENTS.add(instrument);
    }

    public static void addToJigsawPattern(ResourceLocation toAdd, StructurePoolElement newPiece, int weight) {
        StructureTemplatePool oldPool = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(toAdd);
        if (oldPool != null) {
            oldPool.f_210559_.add(Pair.of((Object)newPiece, (Object)weight));
            List jigsawPieces = oldPool.f_210560_;
            for (int i = 0; i < weight; ++i) {
                jigsawPieces.add(newPiece);
            }
        }
    }

    public static void registerConfigCondition(String modId, Object ... configObjects) {
        HashMap configValues = new HashMap();
        for (Object object : configObjects) {
            for (Field field : object.getClass().getDeclaredFields()) {
                if (field.getAnnotation(ConfigKey.class) == null || !ForgeConfigSpec.ConfigValue.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                try {
                    configValues.put(field.getAnnotation(ConfigKey.class).value(), (ForgeConfigSpec.ConfigValue)field.get(object));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        CraftingHelper.register((IConditionSerializer)new ConfigValueCondition.Serializer(modId, configValues));
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation(modId, "config"), (Object)new LootItemConditionType((Serializer)new ConfigLootCondition.ConfigSerializer(modId, configValues)));
    }

    public static void registerConfigPredicate(IConfigPredicateSerializer<?> serializer) {
        ResourceLocation key = serializer.getID();
        if (ConfigValueCondition.Serializer.CONFIG_PREDICATE_SERIALIZERS.containsKey(key)) {
            throw new IllegalStateException("Duplicate config predicate serializer: " + key);
        }
        ConfigValueCondition.Serializer.CONFIG_PREDICATE_SERIALIZERS.put(key, serializer);
    }

    public static List<AlternativeDispenseBehavior> getSortedAlternativeDispenseBehaviors() {
        ArrayList<AlternativeDispenseBehavior> behaviors = new ArrayList<AlternativeDispenseBehavior>(ALTERNATIVE_DISPENSE_BEHAVIORS);
        Collections.sort(behaviors);
        return behaviors;
    }

    public static List<CustomNoteBlockInstrument> getSortedCustomNoteBlockInstruments() {
        ArrayList<CustomNoteBlockInstrument> instruments = new ArrayList<CustomNoteBlockInstrument>(CUSTOM_NOTE_BLOCK_INSTRUMENTS);
        Collections.sort(instruments);
        return instruments;
    }

    public static RegistryOps<JsonElement> createRegistryOps(ReloadableServerResources serverResources) throws IllegalAccessException {
        return RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)REGISTRY_ACCESS.get(TAG_MANAGER.get(serverResources))));
    }

    public static class CustomNoteBlockInstrument
    implements Comparable<CustomNoteBlockInstrument> {
        protected final String modId;
        protected final Comparator<String> modIdComparator;
        protected final Predicate<BlockSource> condition;
        private final SoundEvent sound;

        public CustomNoteBlockInstrument(String modId, Predicate<BlockSource> condition, SoundEvent sound) {
            this(modId, condition, sound, (id1, id2) -> 0);
        }

        public CustomNoteBlockInstrument(String modId, Predicate<BlockSource> condition, SoundEvent sound, Comparator<String> modIdComparator) {
            this.modId = modId;
            this.condition = condition;
            this.sound = sound;
            this.modIdComparator = modIdComparator;
        }

        @Override
        public int compareTo(CustomNoteBlockInstrument instrument) {
            return this.modIdComparator.compare(this.modId, instrument.modId);
        }

        public boolean test(BlockSource source) {
            return this.condition.test(source);
        }

        public SoundEvent getSound() {
            return this.sound;
        }
    }

    public static class AlternativeDispenseBehavior
    implements Comparable<AlternativeDispenseBehavior> {
        protected final String modId;
        protected final Item item;
        protected final BiPredicate<BlockSource, ItemStack> condition;
        protected final DispenseItemBehavior behavior;
        protected final Comparator<String> modIdComparator;

        public AlternativeDispenseBehavior(String modId, Item item, BiPredicate<BlockSource, ItemStack> condition, DispenseItemBehavior behavior) {
            this(modId, item, condition, behavior, (id1, id2) -> 0);
        }

        public AlternativeDispenseBehavior(String modId, Item item, BiPredicate<BlockSource, ItemStack> condition, DispenseItemBehavior behavior, Comparator<String> modIdComparator) {
            this.modId = modId;
            this.item = item;
            this.condition = condition;
            this.behavior = behavior;
            this.modIdComparator = modIdComparator;
        }

        @Override
        public int compareTo(AlternativeDispenseBehavior behavior) {
            return this.item == behavior.item ? this.modIdComparator.compare(this.modId, behavior.modId) : 0;
        }

        public void register() {
            DispenseItemBehavior oldBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(this.item);
            DispenserBlock.m_52672_((ItemLike)this.item, (source, stack) -> this.condition.test(source, stack) ? this.behavior.m_6115_(source, stack) : oldBehavior.m_6115_(source, stack));
        }
    }
}

