/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.item.filling;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import com.teamabnormals.blueprint.core.util.item.filling.IItemCategoryFiller;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class TargetedItemCategoryFiller
implements IItemCategoryFiller {
    private final Supplier<Item> targetItem;
    private final Map<CreativeModeTab, OffsetValue> offsetMap = Maps.newHashMap();

    public TargetedItemCategoryFiller(Supplier<Item> targetItem) {
        this.targetItem = targetItem;
    }

    @Override
    public void fillItem(Item item, CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (ItemStackUtil.isAllowedInTab(item, tab)) {
            int index;
            OffsetValue offset = this.offsetMap.computeIfAbsent(tab, key -> new OffsetValue());
            Set<Item> itemsProcessed = offset.itemsProcessed;
            if (itemsProcessed.contains(item)) {
                offset.reset();
            }
            if ((index = ItemStackUtil.findIndexOfItem(this.targetItem.get(), items)) != -1) {
                items.add(index + offset.offset, (Object)new ItemStack((ItemLike)item));
                itemsProcessed.add(item);
                ++offset.offset;
            } else {
                items.add((Object)new ItemStack((ItemLike)item));
            }
        }
    }

    static class OffsetValue {
        private final Set<Item> itemsProcessed = Sets.newHashSet();
        private int offset = 1;

        OffsetValue() {
        }

        private void reset() {
            this.offset = 1;
            this.itemsProcessed.clear();
        }
    }
}

