/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierSerializerRegistry;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.EventPriority;

public record ObjectModifierGroup<T, S, D>(ConditionedResourceSelector selector, List<ObjectModifier<T, S, D, ?>> modifiers, EventPriority priority) {
    public static EventPriority deserializePriority(JsonObject object) {
        if (object.has("priority")) {
            String priorityName = GsonHelper.m_13906_((JsonObject)object, (String)"priority").toUpperCase();
            for (EventPriority priority : EventPriority.values()) {
                if (!priority.name().equals(priorityName)) continue;
                return priority;
            }
            throw new JsonParseException("Unknown priority type: " + priorityName);
        }
        return EventPriority.NORMAL;
    }

    public static <T, S, D> ObjectModifierGroup<T, S, D> deserialize(String name, JsonObject object, D additional, ObjectModifierSerializerRegistry<T, S, D> registry, boolean logSkipping, boolean allowPriority) throws JsonParseException {
        EventPriority priority = allowPriority ? ObjectModifierGroup.deserializePriority(object) : EventPriority.NORMAL;
        ConditionedResourceSelector selector = ConditionedResourceSelector.deserialize("selector", object.get("selector"));
        if (selector == ConditionedResourceSelector.EMPTY) {
            if (logSkipping) {
                Blueprint.LOGGER.info("Skipped modifier group named '" + name + "' as its conditions were not met");
            }
            return new ObjectModifierGroup<T, S, D>(selector, ImmutableList.of(), priority);
        }
        ArrayList objectModifiers = new ArrayList();
        GsonHelper.m_13933_((JsonObject)object, (String)"modifiers").forEach(element -> {
            JsonObject entry = element.getAsJsonObject();
            if (!GsonHelper.m_13900_((JsonObject)entry, (String)"conditions") || CraftingHelper.processConditions((JsonArray)GsonHelper.m_13933_((JsonObject)entry, (String)"conditions"))) {
                String type = GsonHelper.m_13906_((JsonObject)entry, (String)"type");
                ObjectModifier.Serializer serializer = registry.getSerializer(type);
                if (serializer == null) {
                    throw new JsonParseException("Unknown modifier type: " + type);
                }
                JsonElement config = entry.get("config");
                if (config == null) {
                    throw new JsonParseException("Missing 'config' element!");
                }
                objectModifiers.add(serializer.deserialize(config, additional));
            } else if (logSkipping) {
                Blueprint.LOGGER.info("Skipped modifier named '" + name + "' as its conditions were not met");
            }
        });
        return new ObjectModifierGroup<T, S, D>(selector, objectModifiers, priority);
    }

    public JsonObject serialize(S additional, ObjectModifierSerializerRegistry<T, S, D> registry, ICondition[][] conditions) throws JsonParseException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("selector", this.selector.serialize());
        jsonObject.addProperty("priority", this.priority.toString().toLowerCase());
        List<ObjectModifier<T, S, D, ?>> objectModifiers = this.modifiers;
        JsonArray modifiers = new JsonArray();
        for (int i = 0; i < objectModifiers.size(); ++i) {
            ObjectModifier<T, S, D, ?> modifier = objectModifiers.get(i);
            ObjectModifier.Serializer<?, S, D> serializer = modifier.getSerializer();
            String name = registry.getName(serializer);
            if (name == null) {
                throw new JsonParseException("Could not find name for modifier serializer: " + serializer);
            }
            JsonObject modifierObject = new JsonObject();
            modifierObject.addProperty("type", name);
            modifierObject.add("config", modifier.serialize(additional));
            ICondition[] modifierConditions = conditions[i];
            if (modifierConditions.length > 0) {
                JsonArray conditionsObject = new JsonArray();
                for (ICondition condition : modifierConditions) {
                    conditionsObject.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                modifierObject.add("conditions", (JsonElement)conditionsObject);
            }
            modifiers.add((JsonElement)modifierObject);
        }
        jsonObject.add("modifiers", (JsonElement)modifiers);
        return jsonObject;
    }
}

