/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.SplashElementBase;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ProgressBarSplashElement
extends SplashElementBase {
    public String customBarColorHex = null;
    protected String lastCustomBarColorHex = null;
    public Color customBarColor;

    public ProgressBarSplashElement(SplashCustomizationLayer handler) {
        super(handler);
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91268_() != null) {
            int screenWidth = this.mc.m_91268_().m_85445_();
            int screenHeight = this.mc.m_91268_().m_85446_();
            double d0 = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
            double d1 = d0 * 4.0;
            int k1 = (int)(d1 * 0.5);
            this.width = k1 * 2;
            this.height = 10;
        }
    }

    @Override
    public void onReloadCustomizations() {
        super.onReloadCustomizations();
        this.customBarColorHex = null;
        this.lastCustomBarColorHex = null;
        this.customBarColor = null;
    }

    @Override
    public void render(PoseStack matrix, int scaledWidth, int scaledHeight, float partialTicks) {
        if (this.customBarColorHex != null && !this.customBarColorHex.equals(this.lastCustomBarColorHex)) {
            this.customBarColor = RenderUtils.getColorFromHexString((String)this.customBarColorHex);
        }
        this.lastCustomBarColorHex = this.customBarColorHex;
        if (this.visible) {
            this.renderProgressBar(matrix);
        }
    }

    protected void renderProgressBar(PoseStack matrix) {
        long time = Util.m_137550_();
        float f = this.handler.fadeOutStart > -1L ? (float)(time - this.handler.fadeOutStart) / 1000.0f : -1.0f;
        int screenWidth = this.mc.m_91268_().m_85445_();
        int screenHeight = this.mc.m_91268_().m_85446_();
        double d0 = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
        double d1 = d0 * 4.0;
        int k1 = (int)(d1 * 0.5);
        int l1 = (int)((double)screenHeight * 0.8325);
        float barTransparency = 1.0f - Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        this.width = k1 * 2;
        this.height = 10;
        this.renderProgressBarRaw(matrix, this.x, this.y, this.x + k1 * 2, this.y + 10, barTransparency);
    }

    protected void renderProgressBarRaw(PoseStack matrix, int minX, int minY, int maxX, int maxY, float alpha) {
        float prog = this.handler.currentProgress;
        if (this.handler.isEditor || SplashCustomizationLayer.isCustomizationHelperScreen()) {
            prog = 0.5f;
        }
        int i = Mth.m_14167_((float)((float)(maxX - minX - 2) * prog));
        int j = Math.round(alpha * 255.0f);
        if (this.handler.isEditor || SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded()) {
            j = 255;
        }
        int k = FastColor.ARGB32.m_13660_((int)j, (int)255, (int)255, (int)255);
        if (this.customBarColor != null) {
            k = FastColor.ARGB32.m_13660_((int)j, (int)this.customBarColor.getRed(), (int)this.customBarColor.getGreen(), (int)this.customBarColor.getBlue());
        }
        ProgressBarSplashElement.m_93172_((PoseStack)matrix, (int)(minX + 1), (int)minY, (int)(maxX - 1), (int)(minY + 1), (int)k);
        ProgressBarSplashElement.m_93172_((PoseStack)matrix, (int)(minX + 1), (int)maxY, (int)(maxX - 1), (int)(maxY - 1), (int)k);
        ProgressBarSplashElement.m_93172_((PoseStack)matrix, (int)minX, (int)minY, (int)(minX + 1), (int)maxY, (int)k);
        ProgressBarSplashElement.m_93172_((PoseStack)matrix, (int)maxX, (int)minY, (int)(maxX - 1), (int)maxY, (int)k);
        ProgressBarSplashElement.m_93172_((PoseStack)matrix, (int)(minX + 2), (int)(minY + 2), (int)(minX + i), (int)(maxY - 2), (int)k);
    }
}

