/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet;

import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.IDietTracker;
import top.theillusivec4.diet.client.DietKeys;
import top.theillusivec4.diet.common.command.DietCommand;
import top.theillusivec4.diet.common.command.DietGroupArgument;
import top.theillusivec4.diet.common.config.data.DietConfigReader;
import top.theillusivec4.diet.common.integration.IntegrationManager;
import top.theillusivec4.diet.common.network.DietNetwork;
import top.theillusivec4.diet.common.util.DietOverride;
import top.theillusivec4.diet.common.util.DietValueGenerator;
import top.theillusivec4.diet.data.DietBlockTagsProvider;
import top.theillusivec4.diet.data.DietTagsProvider;

@Mod(value="diet")
public class DietMod {
    public static final String MOD_ID = "diet";
    public static final Logger LOGGER = LogManager.getLogger();

    public static String id(String name) {
        return "diet:" + name;
    }

    public DietMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::process);
        eventBus.addListener(this::gatherData);
        eventBus.addListener(this::registerCaps);
        eventBus.addGenericListener(Attribute.class, this::registerAttributes);
        eventBus.addListener(this::modifyAttributes);
        DietConfigReader.setup();
    }

    private void setup(FMLCommonSetupEvent evt) {
        DietNetwork.setup();
        DietValueGenerator.setup();
        DietCommand.setup();
        IntegrationManager.setup();
        evt.enqueueWork(() -> ArgumentTypes.m_121601_((String)DietMod.id("group"), DietGroupArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(DietGroupArgument::group)));
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        DietKeys.setup();
    }

    private void process(InterModProcessEvent evt) {
        DietOverride.process(evt.getIMCStream());
    }

    private void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        if (evt.includeServer()) {
            ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
            DietBlockTagsProvider blockTagsProvider = new DietBlockTagsProvider(generator, existingFileHelper);
            generator.m_123914_((DataProvider)new DietTagsProvider(generator, blockTagsProvider, existingFileHelper));
        }
    }

    private void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(IDietTracker.class);
    }

    private void registerAttributes(RegistryEvent.Register<Attribute> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)((Attribute)DietApi.getInstance().getNaturalRegeneration().setRegistryName(new ResourceLocation(MOD_ID, "natural_regeneration"))));
    }

    private void modifyAttributes(EntityAttributeModificationEvent evt) {
        evt.add(EntityType.f_20532_, DietApi.getInstance().getNaturalRegeneration());
    }
}

