/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.DietCapability;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietResult;
import top.theillusivec4.diet.client.DietKeys;
import top.theillusivec4.diet.client.DietScreen;
import top.theillusivec4.diet.client.DietTooltip;
import top.theillusivec4.diet.common.config.DietClientConfig;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.integration.CuriosIntegration;
import top.theillusivec4.diet.common.integration.IntegrationManager;
import top.theillusivec4.diet.common.util.DietResult;

@Mod.EventBusSubscriber(modid="diet", value={Dist.CLIENT})
public class DietClientEventsListener {
    private static final TagKey<Item> SPECIAL_FOOD = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("diet", "special_food"));
    private static final DecimalFormat DECIMALFORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.#"), num -> num.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final ResourceLocation ICONS = new ResourceLocation("diet", "textures/gui/icons.png");
    private static List<Component> tooltip = null;
    private static int tooltipX = 0;
    private static int tooltipY = 0;

    @SubscribeEvent
    public static void initGui(ScreenEvent.InitScreenEvent.Post evt) {
        Screen screen = evt.getScreen();
        if (DietClientConfig.addButton && (screen instanceof InventoryScreen || IntegrationManager.isCuriosLoaded() && CuriosIntegration.isCuriosScreen(screen))) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            evt.addListener((GuiEventListener)new DynamicButton(containerScreen, containerScreen.getGuiLeft() + DietClientConfig.buttonX, containerScreen.f_96544_ / 2 + DietClientConfig.buttonY, 20, 18, 0, 0, 19, ICONS, button -> Minecraft.m_91087_().m_91152_((Screen)new DietScreen(true))));
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && evt.phase == TickEvent.Phase.END && mc.m_91302_() && !(mc.f_91080_ instanceof DietScreen) && DietKeys.OPEN_GUI.m_90859_()) {
            mc.m_91152_((Screen)new DietScreen(mc.f_91080_ instanceof InventoryScreen));
        }
    }

    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent evt) {
        Player player = evt.getPlayer();
        List tooltips = evt.getToolTip();
        ItemStack stack = evt.getItemStack();
        if (player != null && player.f_19853_ != null) {
            if (DietServerConfig.hideTooltipsUntilEaten && DietCapability.get(player).map(tracker -> !tracker.getEaten().contains(stack.m_41720_())).orElse(false).booleanValue()) {
                return;
            }
            IDietResult result = DietApi.getInstance().get(player, stack);
            if (result != DietResult.EMPTY) {
                Map<IDietGroup, Float> groups = result.get();
                boolean specialFood = stack.m_204117_(SPECIAL_FOOD);
                if (!groups.isEmpty()) {
                    ArrayList groupsTooltips = new ArrayList();
                    ArrayList<TranslatableComponent> beneficial = new ArrayList<TranslatableComponent>();
                    ArrayList<TranslatableComponent> harmful = new ArrayList<TranslatableComponent>();
                    for (Map.Entry<IDietGroup, Float> entry : groups.entrySet()) {
                        float value = entry.getValue().floatValue();
                        TranslatableComponent groupName = new TranslatableComponent("groups.diet." + entry.getKey().getName() + ".name");
                        TranslatableComponent tooltip = null;
                        if (specialFood) {
                            tooltip = new TranslatableComponent("tooltip.diet.group_", new Object[]{groupName});
                        } else if (value > 0.0f) {
                            tooltip = new TranslatableComponent("tooltip.diet.group", new Object[]{DECIMALFORMAT.format(entry.getValue().floatValue() * 100.0f), groupName});
                        }
                        if (tooltip == null) continue;
                        if (entry.getKey().isBeneficial()) {
                            tooltip.m_130940_(ChatFormatting.GREEN);
                            beneficial.add(tooltip);
                            continue;
                        }
                        tooltip.m_130940_(ChatFormatting.RED);
                        harmful.add(tooltip);
                    }
                    groupsTooltips.addAll(beneficial);
                    groupsTooltips.addAll(harmful);
                    if (!groupsTooltips.isEmpty()) {
                        tooltips.add(TextComponent.f_131282_);
                        tooltips.add(new TranslatableComponent("tooltip.diet.eaten").m_130940_(ChatFormatting.GRAY));
                        tooltips.addAll(groupsTooltips);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderTooltip(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && tooltip != null) {
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (screen != null) {
                screen.m_169388_(new PoseStack(), tooltip, Optional.empty(), tooltipX, tooltipY);
            }
            tooltip = null;
        }
    }

    public static class DynamicButton
    extends ImageButton {
        private final AbstractContainerScreen<?> containerScreen;

        public DynamicButton(AbstractContainerScreen<?> screenIn, int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, Button.OnPress onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
            this.containerScreen = screenIn;
        }

        public void m_6303_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.f_93620_ = this.containerScreen.getGuiLeft() + DietClientConfig.buttonX;
            this.f_93621_ = this.containerScreen.getGuiTop() + DietClientConfig.buttonY + 83;
            super.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public void m_7428_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
            List<Component> tooltips = DietTooltip.getEffects();
            if (!tooltips.isEmpty()) {
                tooltip = tooltips;
                tooltipX = mouseX;
                tooltipY = mouseY;
            }
        }
    }
}

