/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.client.DietScreen;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;

public class DietTooltip {
    public static List<Component> getEffects() {
        List<DietEffectsInfo.AttributeModifier> modifiers = DietScreen.tooltip.getModifiers();
        List<DietEffectsInfo.StatusEffect> effects = DietScreen.tooltip.getEffects();
        if (modifiers.isEmpty() && effects.isEmpty()) {
            return new ArrayList<Component>();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)new TranslatableComponent("tooltip.diet.effects"));
        tooltips.add(TextComponent.f_131282_);
        HashMap<Attribute, AttributeTooltip> mergedAttributes = new HashMap<Attribute, AttributeTooltip>();
        for (DietEffectsInfo.AttributeModifier attributeModifier : modifiers) {
            mergedAttributes.computeIfAbsent(attributeModifier.getAttribute(), k -> new AttributeTooltip()).merge(attributeModifier);
        }
        for (Map.Entry entry : mergedAttributes.entrySet()) {
            AttributeTooltip attributeTooltip = (AttributeTooltip)entry.getValue();
            Attribute key = (Attribute)entry.getKey();
            if (key == DietApi.getInstance().getNaturalRegeneration()) {
                float val = (attributeTooltip.added + attributeTooltip.added * attributeTooltip.baseMultiplier) * attributeTooltip.totalMultiplier;
                if (!(val < 1.0f)) continue;
                tooltips.add((Component)new TranslatableComponent("attribute.diet.modifier.disabled", new Object[]{new TranslatableComponent(key.m_22087_())}).m_130940_(ChatFormatting.RED));
                continue;
            }
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.added, AttributeModifier.Operation.ADDITION, key);
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.baseMultiplier, AttributeModifier.Operation.MULTIPLY_BASE, key);
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.totalMultiplier - 1.0f, AttributeModifier.Operation.MULTIPLY_TOTAL, key);
        }
        HashMap<MobEffect, Integer> mergedEffects = new HashMap<MobEffect, Integer>();
        for (DietEffectsInfo.StatusEffect statusEffect : effects) {
            mergedEffects.compute(statusEffect.getEffect(), (k, v) -> v == null ? statusEffect.getAmplifier() : Math.max(v, statusEffect.getAmplifier()));
        }
        for (Map.Entry entry : mergedEffects.entrySet()) {
            MobEffect effect1 = (MobEffect)entry.getKey();
            TranslatableComponent iformattabletextcomponent = new TranslatableComponent(effect1.m_19481_());
            if ((Integer)entry.getValue() > 0) {
                iformattabletextcomponent = new TranslatableComponent("potion.withAmplifier", new Object[]{iformattabletextcomponent, new TranslatableComponent("potion.potency." + entry.getValue())});
            }
            tooltips.add((Component)iformattabletextcomponent.m_130940_(effect1.m_19483_().m_19497_()));
        }
        return tooltips;
    }

    private static void addAttributeTooltip(List<Component> tooltips, float amount, AttributeModifier.Operation operation, Attribute attribute) {
        double formattedAmount = operation != AttributeModifier.Operation.MULTIPLY_BASE && operation != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute.equals(Attributes.f_22278_) ? (double)amount * 10.0 : (double)amount) : (double)amount * 100.0;
        if ((double)amount > 0.0) {
            tooltips.add((Component)new TranslatableComponent("attribute.modifier.plus." + operation.m_22235_(), new Object[]{ItemStack.f_41584_.format(formattedAmount), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
        } else if ((double)amount < 0.0) {
            tooltips.add((Component)new TranslatableComponent("attribute.modifier.take." + operation.m_22235_(), new Object[]{ItemStack.f_41584_.format(formattedAmount *= -1.0), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.RED));
        }
    }

    private static class AttributeTooltip {
        float added = 0.0f;
        float baseMultiplier = 0.0f;
        float totalMultiplier = 1.0f;

        private AttributeTooltip() {
        }

        void merge(DietEffectsInfo.AttributeModifier modifier) {
            float amount = modifier.getAmount();
            if (modifier.getOperation() == AttributeModifier.Operation.MULTIPLY_BASE) {
                this.baseMultiplier += amount;
            } else if (modifier.getOperation() == AttributeModifier.Operation.MULTIPLY_TOTAL) {
                this.totalMultiplier *= 1.0f + amount;
            } else {
                this.added += amount;
            }
        }
    }
}

