/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.capability;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.diet.DietMod;
import top.theillusivec4.diet.api.DietCapability;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietTracker;
import top.theillusivec4.diet.common.capability.PlayerDietTracker;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.group.DietGroups;

@Mod.EventBusSubscriber(modid="diet")
public class DietCapabilityEventsListener {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Object object = evt.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            PlayerDietTracker tracker = new PlayerDietTracker(player);
            LazyOptional capability = LazyOptional.of(() -> tracker);
            evt.addCapability(DietCapability.DIET_TRACKER_ID, (ICapabilityProvider)new Provider(tracker, (LazyOptional<IDietTracker>)capability));
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone evt) {
        Player player = evt.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Player original = evt.getOriginal();
            original.reviveCaps();
            DietCapability.get((Player)player2).ifPresent(diet -> DietCapability.get(original).ifPresent(originalDiet -> {
                Map<String, Float> originalValues = originalDiet.getValues();
                for (IDietGroup group : DietGroups.get()) {
                    float originalValue;
                    String id = group.getName();
                    float newValue = originalValue = originalValues.getOrDefault(id, Float.valueOf(group.getDefaultValue())).floatValue();
                    if (evt.isWasDeath()) {
                        if (DietServerConfig.deathPenaltyMethod == DietServerConfig.DeathPenaltyMethod.RESET) {
                            newValue = group.getDefaultValue();
                        } else {
                            newValue = DietServerConfig.deathPenaltyMethod == DietServerConfig.DeathPenaltyMethod.AMOUNT ? (newValue -= DietServerConfig.deathPenaltyLoss) : (newValue *= 1.0f - DietServerConfig.deathPenaltyLoss);
                            newValue = Math.min(originalValue, Math.max(newValue, DietServerConfig.deathPenaltyMin));
                        }
                    }
                    diet.setValue(id, newValue);
                }
                diet.setActive(originalDiet.isActive());
                if (!evt.isWasDeath()) {
                    diet.setModifiers(originalDiet.getModifiers());
                }
            }));
            original.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void playerRespawned(PlayerEvent.PlayerRespawnEvent evt) {
        Player player = evt.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DietCapability.get((Player)player2).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DietCapability.get((Player)player2).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerDimensionTravel(PlayerEvent.PlayerChangedDimensionEvent evt) {
        Player player = evt.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DietCapability.get((Player)player2).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side == LogicalSide.SERVER && evt.phase == TickEvent.Phase.END) {
            DietCapability.get(evt.player).ifPresent(IDietTracker::tick);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void finishItemUse(LivingEntityUseItemEvent.Finish evt) {
        FoodProperties food;
        ItemStack stack = evt.getItem();
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.f_19853_.f_46443_ && livingEntity instanceof Player && (food = stack.getFoodProperties(livingEntity)) != null) {
            DietCapability.get((Player)livingEntity).ifPresent(diet -> diet.consume(stack));
        }
    }

    private record Provider(IDietTracker instance, LazyOptional<IDietTracker> capability) implements ICapabilitySerializable<Tag>
    {
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (DietCapability.DIET_TRACKER != null) {
                return DietCapability.DIET_TRACKER.orEmpty(cap, this.capability);
            }
            DietMod.LOGGER.error("Missing Diet capability!");
            return LazyOptional.empty();
        }

        public Tag serializeNBT() {
            if (this.instance != null) {
                CompoundTag tag = new CompoundTag();
                this.instance.save(tag);
                return tag;
            }
            DietMod.LOGGER.error("Missing Diet capability!");
            return new CompoundTag();
        }

        public void deserializeNBT(Tag nbt) {
            if (this.instance != null && nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                this.instance.load(tag);
            } else {
                DietMod.LOGGER.error("Missing Diet capability!");
            }
        }
    }
}

