/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.capability;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.DietEvent;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietResult;
import top.theillusivec4.diet.api.IDietTracker;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.effect.DietEffect;
import top.theillusivec4.diet.common.effect.DietEffects;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;
import top.theillusivec4.diet.common.group.DietGroups;
import top.theillusivec4.diet.common.network.DietNetwork;
import top.theillusivec4.diet.common.util.DietResult;

public class PlayerDietTracker
implements IDietTracker {
    private static final Map<MobEffect, Integer> EFFECT_DURATION = new HashMap<MobEffect, Integer>();
    private final Player player;
    private final Map<String, Float> values = new HashMap<String, Float>();
    private final Map<Attribute, Set<UUID>> activeModifiers = new HashMap<Attribute, Set<UUID>>();
    private final Set<Item> eatenFood = new HashSet<Item>();
    private boolean active = true;
    private int prevFood = 0;
    private ItemStack captured = ItemStack.f_41583_;

    public PlayerDietTracker(Player playerIn) {
        this.player = playerIn;
        for (IDietGroup group : DietGroups.get()) {
            String name = group.getName();
            float amount = group.getDefaultValue();
            this.values.put(name, Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
        }
    }

    @Override
    public void tick() {
        if (this.player instanceof ServerPlayer) {
            if (!this.player.m_7500_() && this.active) {
                int currentFood = this.player.m_36324_().m_38702_();
                if (currentFood < this.prevFood && !MinecraftForge.EVENT_BUS.post((Event)new DietEvent.ApplyDecay(this.player))) {
                    this.decay(this.prevFood - currentFood);
                }
                this.prevFood = currentFood;
            }
            if (this.player.f_19797_ % 80 == 0) {
                for (Map.Entry<Attribute, Set<UUID>> entry : this.activeModifiers.entrySet()) {
                    Set<UUID> uuids = entry.getValue();
                    AttributeInstance att = this.player.m_21051_(entry.getKey());
                    if (att == null) continue;
                    for (UUID uuid : uuids) {
                        att.m_22120_(uuid);
                    }
                }
                this.activeModifiers.clear();
                if (this.active) {
                    this.applyEffects();
                }
            }
        }
    }

    @Override
    public void consume(ItemStack stack, int healing, float saturationModifier) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.m_36324_().m_38702_() && !MinecraftForge.EVENT_BUS.post((Event)new DietEvent.ConsumeItemStack(stack, this.player)) && (result = DietApi.getInstance().get(this.player, stack, healing, saturationModifier)) != DietResult.EMPTY) {
            this.addEaten(stack.m_41720_());
            this.apply(result);
        }
    }

    @Override
    public void consume(List<ItemStack> stacks, int healing, float saturationModifier) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.m_36324_().m_38702_() && (result = DietApi.getInstance().get(this.player, stacks, healing, saturationModifier)) != DietResult.EMPTY) {
            this.apply(result);
        }
    }

    @Override
    public void consume(ItemStack stack) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.m_36324_().m_38702_() && !MinecraftForge.EVENT_BUS.post((Event)new DietEvent.ConsumeItemStack(stack, this.player)) && (result = DietApi.getInstance().get(this.player, stack)) != DietResult.EMPTY) {
            this.addEaten(stack.m_41720_());
            this.apply(result);
        }
    }

    @Override
    public float getValue(String group) {
        return this.values.getOrDefault(group, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void setValue(String group, float amount) {
        this.values.put(group, Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
    }

    @Override
    public Map<String, Float> getValues() {
        return ImmutableMap.copyOf(this.values);
    }

    @Override
    public void setValues(Map<String, Float> entries) {
        this.values.clear();
        this.values.putAll(entries);
    }

    @Override
    public Map<Attribute, Set<UUID>> getModifiers() {
        return ImmutableMap.copyOf(this.activeModifiers);
    }

    @Override
    public void setModifiers(Map<Attribute, Set<UUID>> modifiers) {
        this.activeModifiers.clear();
        this.activeModifiers.putAll(modifiers);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    private void applyEffects() {
        if (MinecraftForge.EVENT_BUS.post((Event)new DietEvent.ApplyEffect(this.getPlayer()))) {
            return;
        }
        List<DietEffect> effects = DietEffects.get();
        DietEffectsInfo info = new DietEffectsInfo();
        for (DietEffect effect : effects) {
            boolean match = true;
            int multiplier = 0;
            for (DietEffect.Condition condition : effect.conditions) {
                int matches = condition.getMatches(this.player, this.values);
                if (matches == 0) {
                    match = false;
                    break;
                }
                if (condition.match != DietEffect.MatchMethod.EVERY) continue;
                multiplier += matches;
            }
            if (!match) continue;
            multiplier = Math.max(1, multiplier);
            for (DietEffect.DietAttribute attribute : effect.attributes) {
                AttributeInstance att = this.player.m_21051_(attribute.attribute);
                AttributeModifier mod = new AttributeModifier(effect.uuid, "Diet group effect", attribute.amount * (double)multiplier, attribute.operation);
                if (att == null || att.m_22109_(mod)) continue;
                att.m_22125_(mod);
                this.activeModifiers.computeIfAbsent(attribute.attribute, k -> new HashSet()).add(effect.uuid);
                info.addModifier(attribute.attribute, mod);
            }
            for (DietEffect.DietStatusEffect statusEffect : effect.statusEffects) {
                int duration = EFFECT_DURATION.getOrDefault(statusEffect.effect, 100);
                MobEffectInstance instance = new MobEffectInstance(statusEffect.effect, duration, statusEffect.power * multiplier, true, false);
                this.player.m_7292_(instance);
                info.addEffect(instance);
            }
        }
        if (this.player instanceof ServerPlayer) {
            DietNetwork.sendEffectsInfoS2C((ServerPlayer)this.player, info);
        }
    }

    private void decay(int foodDiff) {
        HashMap<String, Float> updated = new HashMap<String, Float>();
        long size = this.values.values().stream().filter(val -> val.floatValue() > 0.0f).count();
        if (size <= 0L) {
            return;
        }
        float scale = (float)foodDiff / (float)size;
        scale = (float)((double)scale * Math.pow(1.0f - DietServerConfig.decayPenaltyPerGroup, size - 1L));
        for (IDietGroup group : DietGroups.get()) {
            String name = group.getName();
            float value = this.getValue(name);
            float decay = (float)(Math.exp(value) * (double)scale * group.getDecayMultiplier() / 100.0);
            if (!(decay > 0.0f)) continue;
            value = Mth.m_14036_((float)(value - decay), (float)0.0f, (float)1.0f);
            this.values.replace(name, Float.valueOf(value));
            updated.put(name, Float.valueOf(value));
        }
        if (!updated.isEmpty()) {
            this.sync(updated);
        }
    }

    private void apply(IDietResult result) {
        Map<IDietGroup, Float> entries = result.get();
        HashMap<String, Float> applied = new HashMap<String, Float>();
        for (Map.Entry<IDietGroup, Float> entry : entries.entrySet()) {
            String name = entry.getKey().getName();
            float value = Mth.m_14036_((float)(entry.getValue().floatValue() + this.values.get(name).floatValue()), (float)0.0f, (float)1.0f);
            this.values.replace(name, Float.valueOf(value));
            applied.put(name, Float.valueOf(value));
        }
        if (!applied.isEmpty()) {
            this.sync(applied);
        }
    }

    @Override
    public void sync() {
        this.sync(this.values);
        this.sync(this.active);
        this.sync(this.eatenFood);
    }

    private void sync(Set<Item> values) {
        if (this.player instanceof ServerPlayer) {
            DietNetwork.sendEatenS2C((ServerPlayer)this.player, values);
        }
    }

    private void sync(Map<String, Float> values) {
        if (this.player instanceof ServerPlayer) {
            DietNetwork.sendDietS2C((ServerPlayer)this.player, values);
        }
    }

    private void sync(boolean flag) {
        if (this.player instanceof ServerPlayer) {
            DietNetwork.sendActivationS2C((ServerPlayer)this.player, flag);
        }
    }

    @Override
    public void captureStack(ItemStack stack) {
        this.captured = stack;
    }

    @Override
    public ItemStack getCapturedStack() {
        return this.captured;
    }

    @Override
    public void addEaten(Item item) {
        this.eatenFood.add(item);
        this.sync(Sets.newHashSet((Object[])new Item[]{item}));
    }

    @Override
    public Set<Item> getEaten() {
        return this.eatenFood;
    }

    @Override
    public void setEaten(Set<Item> foods) {
        this.eatenFood.clear();
        this.eatenFood.addAll(foods);
    }

    @Override
    public void save(CompoundTag tag) {
        Map<String, Float> values = this.getValues();
        if (values != null) {
            for (Map.Entry<String, Float> group : values.entrySet()) {
                tag.m_128350_(group.getKey(), group.getValue().floatValue());
            }
        }
        ListTag list = new ListTag();
        Map<Attribute, Set<UUID>> modifiers = this.getModifiers();
        if (modifiers != null) {
            for (Map.Entry<Attribute, Set<UUID>> modifier : modifiers.entrySet()) {
                CompoundTag attributeTag = new CompoundTag();
                attributeTag.m_128365_("AttributeName", (Tag)StringTag.m_129297_((String)Objects.requireNonNull(modifier.getKey().getRegistryName()).toString()));
                ListTag uuids = new ListTag();
                for (UUID uuid : modifier.getValue()) {
                    uuids.add((Object)StringTag.m_129297_((String)uuid.toString()));
                }
                attributeTag.m_128365_("UUIDs", (Tag)uuids);
                list.add((Object)attributeTag);
            }
        }
        tag.m_128365_("Modifiers", (Tag)list);
        list = new ListTag();
        Set<Item> eaten = this.getEaten();
        if (eaten != null) {
            for (Item item : eaten) {
                ResourceLocation rl = item.getRegistryName();
                if (rl == null) continue;
                list.add((Object)StringTag.m_129297_((String)rl.toString()));
            }
        }
        tag.m_128365_("Eaten", (Tag)list);
        tag.m_128379_("Active", this.isActive());
    }

    @Override
    public void load(CompoundTag tag) {
        HashMap<String, Float> groups = new HashMap<String, Float>();
        for (IDietGroup group : DietGroups.get()) {
            String name = group.getName();
            float amount = tag.m_128441_(name) ? tag.m_128457_(name) : group.getDefaultValue();
            groups.put(name, Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
        }
        ListTag list = tag.m_128437_("Modifiers", 10);
        HashMap<Attribute, Set<UUID>> modifiers = new HashMap<Attribute, Set<UUID>>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag attributeTag = list.m_128728_(i);
            Attribute att = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeTag.m_128461_("AttributeName")));
            if (att == null) continue;
            HashSet<UUID> uuids = new HashSet<UUID>();
            ListTag uuidList = attributeTag.m_128437_("UUIDs", 8);
            for (int j = 0; j < uuidList.size(); ++j) {
                uuids.add(UUID.fromString(uuidList.m_128778_(j)));
            }
            modifiers.put(att, uuids);
        }
        list = tag.m_128437_("Eaten", 8);
        HashSet<Item> eaten = new HashSet<Item>();
        for (int i = 0; i < list.size(); ++i) {
            String s = list.m_128778_(i);
            ResourceLocation rl = new ResourceLocation(s);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
            if (item == null) continue;
            eaten.add(item);
        }
        this.setEaten(eaten);
        this.setModifiers(modifiers);
        this.setValues(groups);
        this.setActive(!tag.m_128441_("Active") || tag.m_128471_("Active"));
    }

    static {
        EFFECT_DURATION.put(MobEffects.f_19611_, 300);
        EFFECT_DURATION.put(MobEffects.f_19604_, 300);
    }
}

