/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietResult;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.group.DietGroups;
import top.theillusivec4.diet.common.util.DietOverride;
import top.theillusivec4.diet.common.util.DietResult;
import top.theillusivec4.diet.common.util.DietValueGenerator;

public class DietApiImpl
extends DietApi {
    private static final Attribute NATURAL_REGEN = new RangedAttribute("diet.naturalRegeneration", 1.0, 0.0, 2.0).m_22084_(true);

    @Override
    public Set<IDietGroup> getGroups(Player player, ItemStack input) {
        HashSet<IDietGroup> groups = new HashSet<IDietGroup>();
        HashSet<ItemStack> processed = new HashSet<ItemStack>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayDeque<ItemStack> queue = new ArrayDeque<ItemStack>();
        queue.add(input);
        while (!queue.isEmpty()) {
            ItemStack next = (ItemStack)queue.poll();
            BiFunction<Player, ItemStack, Triple<List<ItemStack>, Integer, Float>> func = DietOverride.get(next.m_41720_());
            if (func != null) {
                List candidates = (List)func.apply(player, next).getLeft();
                if (candidates.isEmpty()) {
                    stacks.add(next);
                    continue;
                }
                for (ItemStack candidate : candidates) {
                    if (processed.add(candidate)) {
                        queue.add(candidate);
                        continue;
                    }
                    stacks.add(candidate);
                }
                continue;
            }
            stacks.add(next);
        }
        for (ItemStack stack : stacks) {
            HashSet<IDietGroup> found = new HashSet<IDietGroup>();
            for (IDietGroup group : DietGroups.get()) {
                if (!group.contains(stack)) continue;
                found.add(group);
            }
            if (found.isEmpty()) {
                groups.addAll(DietValueGenerator.get(stack.m_41720_()).orElse(new HashSet()));
                continue;
            }
            groups.addAll(found);
        }
        return groups.isEmpty() ? (Set)DietValueGenerator.get(input.m_41720_()).orElse(new HashSet()) : groups;
    }

    @Override
    public IDietResult get(Player player, ItemStack input) {
        float saturation;
        float healing;
        Set<IDietGroup> groups = this.getGroups(player, input);
        if (groups.isEmpty()) {
            return DietResult.EMPTY;
        }
        Item item = input.m_41720_();
        FoodProperties food = input.getFoodProperties((LivingEntity)player);
        BiFunction<Player, ItemStack, Triple<List<ItemStack>, Integer, Float>> func = DietOverride.get(item);
        Float override = DietServerConfig.foodOverrides.get(item);
        if (override != null) {
            healing = override.floatValue();
            saturation = 0.0f;
        } else if (func != null) {
            Triple<List<ItemStack>, Integer, Float> apply = func.apply(player, input);
            healing = ((Integer)apply.getMiddle()).intValue();
            saturation = ((Float)apply.getRight()).floatValue();
        } else if (food != null) {
            healing = food.m_38744_();
            saturation = food.m_38745_();
            if (healing == 0.0f) {
                return DietResult.EMPTY;
            }
        } else {
            HashMap<IDietGroup, Float> result = new HashMap<IDietGroup, Float>();
            for (IDietGroup group : groups) {
                result.put(group, Float.valueOf(0.0f));
            }
            return new DietResult(result);
        }
        return new DietResult(DietApiImpl.calculate(healing, saturation, groups));
    }

    @Override
    public IDietResult get(Player player, ItemStack input, int healing, float saturation) {
        return this.get(player, Collections.singletonList(input), healing, saturation);
    }

    @Override
    public IDietResult get(Player player, List<ItemStack> stacks, int food, float saturation) {
        HashSet<IDietGroup> groups = new HashSet<IDietGroup>();
        for (ItemStack stack : stacks) {
            groups.addAll(this.getGroups(player, stack));
        }
        if (groups.isEmpty()) {
            return DietResult.EMPTY;
        }
        return new DietResult(DietApiImpl.calculate(food, saturation, groups));
    }

    private static Map<IDietGroup, Float> calculate(float healing, float saturation, Set<IDietGroup> groups) {
        float quality = (healing + healing * saturation) / (float)groups.size();
        float gain = quality * 0.25f / (quality + 15.0f);
        gain = (float)((double)gain * Math.pow(1.0f - DietServerConfig.gainPenaltyPerGroup, groups.size() - 1));
        HashMap<IDietGroup, Float> result = new HashMap<IDietGroup, Float>();
        for (IDietGroup group : groups) {
            float value = (float)((double)gain * group.getGainMultiplier());
            value = Math.max(0.005f, (float)Math.round(value * 200.0f) / 200.0f);
            result.put(group, Float.valueOf(value));
        }
        return result;
    }

    @Override
    public Attribute getNaturalRegeneration() {
        return NATURAL_REGEN;
    }
}

