/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.network.server;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.diet.client.DietClientPacketReceiver;

public class SPacketDiet {
    public final Map<String, Float> groups;

    public SPacketDiet(Map<String, Float> groups) {
        this.groups = groups;
    }

    public static void encode(SPacketDiet msg, FriendlyByteBuf buf) {
        for (Map.Entry<String, Float> entry : msg.groups.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.writeFloat(entry.getValue().floatValue());
        }
    }

    public static SPacketDiet decode(FriendlyByteBuf buf) {
        TreeMap<String, Float> groups = new TreeMap<String, Float>();
        while (buf.isReadable()) {
            String name = buf.m_130277_();
            float value = buf.readFloat();
            groups.put(name, Float.valueOf(value));
        }
        return new SPacketDiet(groups);
    }

    public static void handle(SPacketDiet msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DietClientPacketReceiver.handleDiet(msg));
        ctx.get().setPacketHandled(true);
    }
}

