/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.idas;

import com.craisinlord.idas.item.ModItems;
import com.craisinlord.idas.misc.maptrades.StructureMapManager;
import com.craisinlord.idas.misc.maptrades.StructureMapTradesEvents;
import com.craisinlord.idas.misc.pooladditions.PoolAdditionMerger;
import com.craisinlord.idas.misc.structurepiececounter.JSONConditionsRegistry;
import com.craisinlord.idas.misc.structurepiececounter.StructurePieceCountsManager;
import com.craisinlord.idas.modinit.IDASPlacements;
import com.craisinlord.idas.modinit.IDASPredicates;
import com.craisinlord.idas.modinit.IDASProcessors;
import com.craisinlord.idas.modinit.IDASStructures;
import com.craisinlord.idas.sound.ModSounds;
import com.craisinlord.idas.utils.GeneralUtils;
import java.nio.file.Path;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="idas")
public class IDAS {
    public static final String MODID = "idas";
    public static final Logger LOGGER = LogManager.getLogger();
    public static StructureMapManager structureMapManager = new StructureMapManager();
    public static StructurePieceCountsManager structurePieceCountsManager = new StructurePieceCountsManager();

    public IDAS() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(eventBus);
        ModSounds.register(eventBus);
        eventBus.addListener(this::setup);
        JSONConditionsRegistry.registerTestJSONCondition();
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("idas-forge"), (String)"idas-forge");
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.addListener(this::serverStarted);
        forgeBus.addListener(this::registerDatapackListener);
        forgeBus.addListener(StructureMapTradesEvents::onVillagerTradesEvent);
        forgeBus.addListener(StructureMapTradesEvents::onWandererTradesEvent);
        forgeBus.addListener(PoolAdditionMerger::mergeAdditionPools);
        modEventBus.addListener(this::setup);
        IDASStructures.STRUCTURE_FEATURES.register(modEventBus);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            IDASProcessors.registerProcessors();
            IDASPredicates.registerPredicates();
            IDASPlacements.registerPlacements();
            IDASStructures.setupStructures();
        });
    }

    public void registerDatapackListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)structureMapManager);
        event.addListener((PreparableReloadListener)structurePieceCountsManager);
    }

    public void serverStarted(ServerStartedEvent event) {
        GeneralUtils.clearCache();
    }
}

