/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.idas.misc.maptrades;

import com.mojang.datafixers.util.Pair;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class StructureSpecificMaps {

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final ResourceKey<ConfiguredStructureFeature<?, ?>> destination;
        private final TagKey<ConfiguredStructureFeature<?, ?>> destinationTag;
        private final String displayName;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;
        private final int spawnRegionSearchRadius;

        public TreasureMapForEmeralds(int emeraldCost, String csf, String displayName, MapDecoration.Type mapIcon, int maxUse, int xp, int spawnRegionSearchRadius) {
            this.emeraldCost = emeraldCost;
            if (csf.startsWith("#")) {
                this.destination = null;
                this.destinationTag = TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation(csf.replaceFirst("#", "")));
            } else {
                this.destination = ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation(csf));
                this.destinationTag = null;
            }
            this.displayName = displayName;
            this.destinationType = mapIcon;
            this.maxUses = maxUse;
            this.villagerXp = xp;
            this.spawnRegionSearchRadius = spawnRegionSearchRadius;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity entity, Random random) {
            BlockPos blockpos = null;
            Level level = entity.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)level;
            if (this.destinationTag != null) {
                blockpos = serverlevel.m_207561_(this.destinationTag, entity.m_142538_(), this.spawnRegionSearchRadius, true);
            } else {
                Registry registry = serverlevel.m_5962_().m_175515_(Registry.f_122882_);
                HolderSet.Direct holderset = HolderSet.m_205809_((Holder[])new Holder[]{registry.m_206081_(this.destination)});
                Pair pairResult = serverlevel.m_7726_().m_8481_().m_207970_(serverlevel, (HolderSet)holderset, entity.m_142538_(), this.spawnRegionSearchRadius, true);
                if (pairResult != null) {
                    blockpos = (BlockPos)pairResult.getFirst();
                }
            }
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.destinationType);
                itemstack.m_41714_((Component)new TranslatableComponent(this.displayName));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)Items.f_42522_), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }
}

