/*
 * Decompiled with CFR 0.152.
 */
package terrablender.mixin;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import terrablender.worldgen.IExtendedBiomeSource;

@Mixin(value={BiomeSource.class})
public abstract class MixinBiomeSource
implements BiomeResolver,
IExtendedBiomeSource {
    @Shadow
    public Set<Holder<Biome>> f_47891_;
    @Shadow
    public Supplier<List<BiomeSource.StepFeatureData>> f_186695_;
    private List<Holder<Biome>> originalBiomeList;
    private boolean hasAppended = false;

    @Shadow
    abstract List<BiomeSource.StepFeatureData> m_186727_(List<Holder<Biome>> var1, boolean var2);

    @Inject(method={"<init>(Ljava/util/List;)V"}, at={@At(value="RETURN")})
    protected void onInit(List<Holder<Biome>> biomeList, CallbackInfo ci) {
        this.originalBiomeList = biomeList;
    }

    @Inject(method={"Lnet/minecraft/world/level/biome/BiomeSource;lambda$new$0(Ljava/util/List;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipInitialFeaturesPerStep(List<Holder<Biome>> possibleBiomes, CallbackInfoReturnable<List<BiomeSource.StepFeatureData>> cir) {
        cir.setReturnValue(new ArrayList());
    }

    @Override
    public void appendDeferredBiomesList(List<Holder<Biome>> biomesToAppend) {
        if (this.hasAppended) {
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.originalBiomeList);
        builder.addAll(biomesToAppend);
        ImmutableList biomeList = (ImmutableList)builder.build().stream().distinct().collect(ImmutableList.toImmutableList());
        this.f_47891_ = new ObjectLinkedOpenHashSet((Collection)biomeList);
        this.hasAppended = true;
    }

    @Override
    public void updateFeaturesPerStep() {
        this.f_186695_ = Suppliers.memoize(() -> this.m_186727_((List<Holder<Biome>>)ImmutableList.copyOf(this.f_47891_), true));
    }
}

