/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.registry;

import com.anthonyhilyard.iceberg.registry.AutoRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;

public abstract class RendererRegistrar {
    private static Map<EntityType<? extends Entity>, EntityRendererProvider<?>> entityRenderers = new HashMap();

    protected static <T extends Entity> void registerRenderer(String name, EntityRendererProvider<T> rendererProvider) {
        if (!AutoRegistry.isEntityTypeRegistered(name)) {
            throw new RuntimeException("Tried to register a renderer for an unregistered entity type!  Make sure you register renderers after entities.");
        }
        entityRenderers.put(AutoRegistry.getEntityType(name), rendererProvider);
    }

    private <T extends Entity> void onEntityCreation(EntityRenderersEvent.RegisterRenderers event) {
        for (EntityType<? extends Entity> entityType : entityRenderers.keySet()) {
            event.registerEntityRenderer(entityType, entityRenderers.get(entityType));
        }
    }
}

