/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.api;

import ht.treechop.api.ChopData;
import ht.treechop.api.TreeData;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class ChopEvent
extends Event {
    private final Level level;
    private final Player player;
    private final BlockPos choppedBlockPos;
    private final BlockState choppedBlockState;

    public ChopEvent(Level level, Player player, BlockPos choppedBlockPos, BlockState choppedBlockState) {
        this.level = level;
        this.player = player;
        this.choppedBlockPos = choppedBlockPos;
        this.choppedBlockState = choppedBlockState;
    }

    public Level getLevel() {
        return this.level;
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getChoppedBlockPos() {
        return this.choppedBlockPos;
    }

    public BlockState getChoppedBlockState() {
        return this.choppedBlockState;
    }

    public static class FinishChopEvent
    extends ChopEvent {
        public FinishChopEvent(Level level, Player player, BlockPos choppedBlockPos, BlockState choppedBlockState) {
            super(level, player, choppedBlockPos, choppedBlockState);
        }
    }

    @Cancelable
    public static class StartChopEvent
    extends ChopEvent {
        private final Object trigger;
        private final ChopData chopData;

        public StartChopEvent(Level level, ServerPlayer player, BlockPos choppedBlockPos, BlockState choppedBlockState, ChopData chopData) {
            this(level, player, choppedBlockPos, choppedBlockState, chopData, null);
        }

        public StartChopEvent(Level level, ServerPlayer player, BlockPos choppedBlockPos, BlockState choppedBlockState, ChopData chopData, Object trigger) {
            super(level, (Player)player, choppedBlockPos, choppedBlockState);
            this.chopData = chopData;
            this.trigger = trigger;
        }

        public int getNumChops() {
            return this.chopData.getNumChops();
        }

        public boolean getFelling() {
            return this.chopData.getFelling();
        }

        public void setNumChops(int numChops) {
            this.chopData.numChops = numChops;
        }

        public void setFelling(boolean felling) {
            this.chopData.felling = felling;
        }

        public Object getTrigger() {
            return this.trigger;
        }
    }

    @Cancelable
    public static class DetectTreeEvent
    extends ChopEvent {
        private final TreeData treeData;

        public DetectTreeEvent(Level level, ServerPlayer player, BlockPos choppedBlockPos, BlockState choppedBlockState, TreeData treeData) {
            super(level, (Player)player, choppedBlockPos, choppedBlockState);
            this.treeData = treeData;
        }

        public void overrideTreeHasLeaves(boolean hasLeaves) {
            this.treeData.setLeaves(hasLeaves);
        }
    }
}

