/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.api.ChopData;
import ht.treechop.api.ChopEvent;
import ht.treechop.api.TreeData;
import ht.treechop.common.platform.Platform;
import ht.treechop.common.registry.ForgeModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class ForgePlatform
implements Platform {
    @Override
    public boolean onStartBlockBreak(Player player, ItemStack tool, BlockPos blockPos) {
        return !tool.m_41720_().onBlockStartBreak(tool, blockPos, player);
    }

    @Override
    public TreeData detectTreeEvent(Level level, ServerPlayer agent, BlockPos blockPos, BlockState blockState, boolean overrideLeaves) {
        TreeData treeData = new TreeData(overrideLeaves);
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)new ChopEvent.DetectTreeEvent(level, agent, blockPos, blockState, treeData));
        if (canceled) {
            return TreeData.empty();
        }
        return treeData;
    }

    @Override
    public boolean startChopEvent(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ChopData chopData, Object trigger) {
        ChopEvent.StartChopEvent startChopEvent = new ChopEvent.StartChopEvent((Level)level, agent, pos, blockState, chopData, trigger);
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)startChopEvent);
        return !canceled;
    }

    @Override
    public void finishChopEvent(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ChopData chopData) {
        MinecraftForge.EVENT_BUS.post((Event)new ChopEvent.FinishChopEvent((Level)level, (Player)agent, pos, blockState));
    }

    @Override
    public Block getChoppedLogBlock() {
        return (Block)ForgeModBlocks.CHOPPED_LOG.get();
    }

    @Override
    public BlockEntityType<?> getChoppedLogBlockEntity() {
        return (BlockEntityType)ForgeModBlocks.CHOPPED_LOG_ENTITY.get();
    }

    @Override
    public boolean doItemDamage(ItemStack stack, Level level, BlockState blockState, BlockPos pos, Player agent) {
        ItemStack mockItemStack = stack.m_41777_();
        stack.m_41686_(level, blockState, pos, agent);
        if (stack.m_41619_() && !mockItemStack.m_41619_()) {
            ForgeEventFactory.onPlayerDestroyItem((Player)agent, (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND);
            return true;
        }
        return false;
    }
}

