/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.common.network.ClientRequestSettingsPacket;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.network.PacketHandler;
import ht.treechop.common.network.ServerConfirmSettingsPacket;
import ht.treechop.common.network.ServerPermissionsPacket;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class ForgePacketHandler
implements PacketHandler {
    private static final String PROTOCOL = "7";
    public static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("treechop-channel"), () -> "7", "7"::equals, "7"::equals);

    public static void init() {
        int id = 0;
        HANDLER.registerMessage(id++, ClientRequestSettingsPacket.class, ClientRequestSettingsPacket::encode, ClientRequestSettingsPacket::decode, (packet, context) -> ClientRequestSettingsPacket.handle(packet, ((NetworkEvent.Context)context.get()).getSender(), arg_0 -> ForgePacketHandler.lambda$init$1((Supplier)context, arg_0)));
        HANDLER.registerMessage(id++, ServerConfirmSettingsPacket.class, ServerConfirmSettingsPacket::encode, ServerConfirmSettingsPacket::decode, PacketProcessor.toClient((message, sender) -> ServerConfirmSettingsPacket.handle(message)));
        HANDLER.registerMessage(id++, ServerPermissionsPacket.class, ServerPermissionsPacket::encode, ServerPermissionsPacket::decode, PacketProcessor.toClient((message, sender) -> ServerPermissionsPacket.handle(message)));
        HANDLER.registerMessage(id++, ServerUpdateChopsPacket.class, ServerUpdateChopsPacket::encode, ServerUpdateChopsPacket::decode, PacketProcessor.toClient((message, sender) -> ServerUpdateChopsPacket.handle(message, sender.f_19853_)));
    }

    private static /* synthetic */ void lambda$init$1(Supplier context, CustomPacket reply) {
        HANDLER.sendTo((Object)reply, ((NetworkEvent.Context)context.get()).getNetworkManager(), NetworkDirection.PLAY_TO_CLIENT);
    }

    record PacketProcessor<T>(BiConsumer<T, ServerPlayer> handler, LogicalSide receiverSide) implements BiConsumer<T, Supplier<NetworkEvent.Context>>
    {
        public static <T> PacketProcessor<T> toServer(BiConsumer<T, ServerPlayer> handler) {
            return new PacketProcessor<T>(handler, LogicalSide.SERVER);
        }

        public static <T> PacketProcessor<T> toClient(BiConsumer<T, ServerPlayer> handler) {
            return new PacketProcessor<T>(handler, LogicalSide.CLIENT);
        }

        @Override
        public void accept(T message, Supplier<NetworkEvent.Context> context) {
            if (context.get().getDirection().getReceptionSide() == this.receiverSide) {
                context.get().enqueueWork(() -> this.handler.accept(message, ((NetworkEvent.Context)context.get()).getSender()));
            }
            context.get().setPacketHandled(true);
        }
    }
}

