/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChop;
import ht.treechop.api.ChopData;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.TreeData;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.EntityChopSettings;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.Chop;
import ht.treechop.common.util.ChopResult;
import ht.treechop.server.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class ChopUtil {
    public static boolean isBlockChoppable(Level level, BlockPos pos, BlockState blockState) {
        return blockState.m_60734_() instanceof IChoppableBlock || ChopUtil.isBlockALog(blockState);
    }

    public static boolean isBlockChoppable(Level level, BlockPos pos) {
        return ChopUtil.isBlockChoppable(level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockALog(BlockState blockState) {
        return blockState.m_204336_(ConfigHandler.COMMON.blockTagForDetectingLogs.get());
    }

    public static boolean isBlockALog(Level level, BlockPos pos) {
        return ChopUtil.isBlockALog(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(Level level, BlockPos pos) {
        return ChopUtil.isBlockLeaves(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(BlockState blockState) {
        if (blockState.m_204336_(ConfigHandler.COMMON.blockTagForDetectingLeaves.get())) {
            return (Boolean)ConfigHandler.COMMON.ignorePersistentLeaves.get() == false || !blockState.m_61138_((Property)LeavesBlock.f_54419_) || (Boolean)blockState.m_61143_((Property)LeavesBlock.f_54419_) == false;
        }
        return false;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        List<Object> newConnectedBlocks = new LinkedList<BlockPos>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((BlockPos)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks) {
        return ChopUtil.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static List<BlockPos> getTreeLeaves(Level level, Collection<BlockPos> treeBlocks) {
        AtomicInteger iterationCounter = new AtomicInteger();
        HashSet leaves = new HashSet();
        int maxDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
        int maxNumLeavesBlocks = (Integer)ConfigHandler.COMMON.maxNumLeavesBlocks.get();
        ChopUtil.getConnectedBlocks(treeBlocks, pos1 -> {
            BlockState blockState = level.m_8055_(pos1);
            return (ChopUtil.isBlockLeaves(blockState) && !(blockState.m_60734_() instanceof LeavesBlock) ? BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS : BlockNeighbors.ADJACENTS).asStream((BlockPos)pos1).filter(pos2 -> ChopUtil.markLeavesToDestroyAndKeepLooking(level, pos2, iterationCounter, leaves, maxDistance));
        }, maxNumLeavesBlocks, iterationCounter);
        if (leaves.size() >= maxNumLeavesBlocks) {
            TreeChop.LOGGER.warn(String.format("Max number of leaves reached: %d >= %d blocks", leaves.size(), maxNumLeavesBlocks));
        }
        return new ArrayList<BlockPos>(leaves);
    }

    private static boolean markLeavesToDestroyAndKeepLooking(Level level, BlockPos pos, AtomicInteger iterationCounter, Set<BlockPos> leavesToDestroy, int maxDistance) {
        BlockState blockState = level.m_8055_(pos);
        if (ChopUtil.isBlockLeaves(blockState)) {
            if (blockState.m_60734_() instanceof LeavesBlock ? iterationCounter.get() + 1 > (Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) : iterationCounter.get() >= maxDistance) {
                return false;
            }
            leavesToDestroy.add(pos);
            return true;
        }
        return false;
    }

    public static int numChopsToFell(int numBlocks) {
        return ((ChopCountingAlgorithm)((Object)ConfigHandler.COMMON.chopCountingAlgorithm.get())).calculate(numBlocks);
    }

    public static ChopResult getChopResult(Level level, BlockPos blockPos, Player agent, int numChops, boolean fellIfPossible, Predicate<BlockPos> logCondition) {
        return fellIfPossible ? ChopUtil.getChopResult(level, blockPos, agent, numChops, logCondition) : ChopUtil.tryToChopWithoutFelling(level, blockPos, numChops);
    }

    private static ChopResult getChopResult(Level level, BlockPos blockPos, Player agent, int numChops, Predicate<BlockPos> logCondition) {
        TreeData tree = ChopUtil.getTreeBlocks(level, blockPos, logCondition);
        if (tree.isAProperTree(ChopUtil.getPlayerChopSettings(agent).getTreesMustHaveLeaves())) {
            Set<BlockPos> supportedBlocks = tree.getLogBlocks().orElse(Collections.emptySet());
            return ChopUtil.getChopResult(level, blockPos, supportedBlocks, numChops);
        }
        return ChopResult.IGNORED;
    }

    public static TreeData getTreeBlocks(Level level, BlockPos blockPos) {
        return ChopUtil.getTreeBlocks(level, blockPos, pos -> ChopUtil.isBlockALog(level, pos));
    }

    public static TreeData getTreeBlocks(Level level, BlockPos blockPos, Predicate<BlockPos> logCondition) {
        if (!logCondition.test(blockPos)) {
            return new TreeData();
        }
        TreeData detectData = TreeChop.platform.detectTreeEvent(level, null, blockPos, level.m_8055_(blockPos), false);
        if (detectData.getLogBlocks().isPresent()) {
            return detectData;
        }
        int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        Set<BlockPos> supportedBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)somePos).peek(pos -> detectData.setLeaves(detectData.hasLeaves() || ChopUtil.isBlockLeaves(level, pos))).filter(logCondition), maxNumTreeBlocks);
        if (supportedBlocks.size() >= maxNumTreeBlocks) {
            TreeChop.LOGGER.warn(String.format("Max tree size reached: %d >= %d blocks (not including leaves)", supportedBlocks.size(), maxNumTreeBlocks));
        }
        detectData.setLogBlocks(supportedBlocks);
        return detectData;
    }

    private static ChopResult getChopResult(Level level, BlockPos target, Set<BlockPos> supportedBlocks, int numChops) {
        int numChopsToFell;
        if (supportedBlocks.isEmpty()) {
            return ChopResult.IGNORED;
        }
        BlockState blockState = level.m_8055_(target);
        int currentNumChops = ChopUtil.getNumChops(level, target, blockState);
        if (currentNumChops + numChops < (numChopsToFell = ChopUtil.numChopsToFell(supportedBlocks.size()))) {
            Set<BlockPos> nearbyChoppableBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(target), pos -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((BlockPos)pos).filter(checkPos -> Math.abs(checkPos.m_123342_() - target.m_123342_()) < 4 && ChopUtil.isBlockChoppable(level, checkPos)), 64);
            int totalNumChops = ChopUtil.getNumChops(level, nearbyChoppableBlocks) + numChops;
            if (totalNumChops >= numChopsToFell) {
                List choppedLogsSortedByY = nearbyChoppableBlocks.stream().filter(pos1 -> level.m_8055_(pos1).m_60734_() instanceof IChoppableBlock).sorted(Comparator.comparingInt(Vec3i::m_123342_)).collect(Collectors.toList());
                for (BlockPos pos2 : choppedLogsSortedByY) {
                    int chops = ChopUtil.getNumChops(level, pos2);
                    supportedBlocks.add(pos2);
                    if (chops <= numChopsToFell) continue;
                    break;
                }
            } else {
                nearbyChoppableBlocks.remove(target);
                return ChopUtil.gatherChops(level, target, numChops, nearbyChoppableBlocks);
            }
        }
        Chop chop = new Chop(target, numChops);
        return new ChopResult(level, Collections.singletonList(chop), supportedBlocks);
    }

    private static ChopResult gatherChops(Level level, BlockPos target, int numChops, Set<BlockPos> nearbyChoppableBlocks) {
        List sortedChoppableBlocks;
        Stack<Chop> chops = new Stack<Chop>();
        int numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, target, numChops, chops);
        if (numChopsLeft > 0 && (sortedChoppableBlocks = nearbyChoppableBlocks.stream().filter(pos -> {
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60734_() instanceof IChoppableBlock) {
                return ChopUtil.getNumChops(level, pos, blockState) < ChopUtil.getMaxNumChops(level, pos, blockState);
            }
            return pos.m_123342_() >= target.m_123342_();
        }).sorted(Comparator.comparingInt(a -> ChopUtil.chopDistance(target, a))).collect(Collectors.toList())).size() > 0) {
            int nextChoiceDistance = ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(0));
            int candidateStartIndex = 0;
            int n = sortedChoppableBlocks.size();
            for (int i = 0; i <= n; ++i) {
                BlockPos nextTarget;
                if (i != n && ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(i)) <= nextChoiceDistance) continue;
                List candidates = sortedChoppableBlocks.subList(candidateStartIndex, i);
                Collections.shuffle(candidates);
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext() && (numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, nextTarget = (BlockPos)iterator.next(), numChopsLeft, chops)) > 0) {
                }
                if (numChopsLeft <= 0) break;
                candidateStartIndex = i;
            }
        }
        return new ChopResult(level, chops, Collections.emptyList());
    }

    private static int gatherChopAndGetNumChopsRemaining(Level level, BlockPos targetPos, int numChops, List<Chop> choppedBlocks) {
        BlockState blockStateBeforeChopping = level.m_8055_(targetPos);
        if (!(blockStateBeforeChopping.m_60734_() instanceof IChoppableBlock) && ChopUtil.isBlockSurrounded(level, targetPos)) {
            return numChops;
        }
        int adjustedNumChops = ChopUtil.adjustNumChops(level, targetPos, blockStateBeforeChopping, numChops, false);
        if (adjustedNumChops > 0) {
            choppedBlocks.add(new Chop(targetPos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static boolean isBlockSurrounded(Level level, BlockPos pos) {
        return Stream.of(pos.m_142125_(), pos.m_142127_(), pos.m_142126_(), pos.m_142128_()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }

    public static int adjustNumChops(Level level, BlockPos blockPos, BlockState blockState, int numChops, boolean destructive) {
        Block choppedBlock = ChopUtil.getChoppedBlock(blockState);
        if (choppedBlock instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)choppedBlock;
            if (destructive) {
                return numChops;
            }
            int currentNumChops = blockState.m_60713_(choppedBlock) ? choppableBlock.getNumChops((BlockGetter)level, blockPos, blockState) : 0;
            int maxNondestructiveChops = choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    public static int getMaxNumChops(Level level, BlockPos blockPos, BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof IChoppableBlock) {
            return ((IChoppableBlock)block).getMaxNumChops((BlockGetter)level, blockPos, blockState);
        }
        if (ChopUtil.isBlockChoppable(level, blockPos, level.m_8055_(blockPos))) {
            int n;
            Block choppedBlock = ChopUtil.getChoppedBlock(blockState);
            if (choppedBlock instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)choppedBlock;
                n = choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState);
            } else {
                n = 0;
            }
            return n;
        }
        return 0;
    }

    public static Block getChoppedBlock(BlockState blockState) {
        if (ChopUtil.isBlockALog(blockState)) {
            return blockState.m_60734_() instanceof IChoppableBlock ? blockState.m_60734_() : TreeChop.platform.getChoppedLogBlock();
        }
        return null;
    }

    public static int getNumChops(Level level, BlockPos pos) {
        return ChopUtil.getNumChops(level, pos, level.m_8055_(pos));
    }

    public static int getNumChops(Level level, BlockPos pos, BlockState blockState) {
        int n;
        Block block = blockState.m_60734_();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops((BlockGetter)level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(Level level, Set<BlockPos> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.m_8055_(pos))).map(posAndblockState -> {
            Integer n;
            Block patt16100$temp = ((BlockState)posAndblockState.getRight()).m_60734_();
            if (patt16100$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt16100$temp;
                n = choppableBlock.getNumChops((BlockGetter)level, (BlockPos)posAndblockState.getLeft(), (BlockState)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(Level level, BlockPos blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(level, blockPos) ? new ChopResult(level, Collections.singletonList(new Chop(blockPos, numChops)), Collections.emptyList()) : ChopResult.IGNORED;
    }

    public static int chopDistance(BlockPos a, BlockPos b) {
        return a.m_123333_((Vec3i)b);
    }

    public static boolean canChopWithTool(ItemStack tool) {
        return ConfigHandler.canChopWithItem(tool.m_41720_());
    }

    public static int getNumChopsByTool(ItemStack tool, BlockState blockState) {
        Item item = tool.m_41720_();
        if (item instanceof IChoppingItem) {
            IChoppingItem choppingItem = (IChoppingItem)item;
            return choppingItem.getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(Player player) {
        EntityChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToChop(player, chopSettings);
    }

    public static boolean playerWantsToChop(Player player, ChopSettings chopSettings) {
        if (player != null && !player.m_7500_() || chopSettings.getChopInCreativeMode()) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(Player player) {
        EntityChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToFell(player, chopSettings);
    }

    public static boolean playerWantsToFell(Player player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
    }

    public static EntityChopSettings getPlayerChopSettings(Player player) {
        return Server.instance().getPlayerChopSettings(player);
    }

    public static void doItemDamage(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, Player agent) {
        ItemStack mockItemStack = itemStack.m_41777_();
        itemStack.m_41686_(level, blockState, blockPos, agent);
        if (itemStack.m_41619_() && !mockItemStack.m_41619_()) {
            TreeChop.platform.doItemDamage(itemStack, level, blockState, blockPos, agent);
        }
    }

    public static void dropExperience(Level level, BlockPos pos, int amount) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_46469_().m_46207_(GameRules.f_46136_)) {
                ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)pos), (int)amount);
            }
        }
    }

    public static boolean chop(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ItemStack tool, Object trigger) {
        if (!(ChopUtil.isBlockALog(blockState) && ((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && ChopUtil.canChopWithTool(tool))) {
            return false;
        }
        ChopData chopData = new ChopData(ChopUtil.getNumChopsByTool(tool, blockState), ChopUtil.playerWantsToFell((Player)agent));
        boolean doChop = TreeChop.platform.startChopEvent(agent, level, pos, blockState, chopData, trigger);
        if (!doChop) {
            return false;
        }
        ChopResult chopResult = ChopUtil.getChopResult((Level)level, pos, (Player)agent, chopData.getNumChops(), chopData.getFelling(), logPos -> ChopUtil.isBlockALog((Level)level, logPos));
        if (chopResult != ChopResult.IGNORED && chopResult.apply(pos, agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get())) {
            if (!agent.m_7500_()) {
                TreeChop.platform.doItemDamage(tool, (Level)level, blockState, pos, (Player)agent);
            }
            TreeChop.platform.finishChopEvent(agent, level, pos, blockState, chopData);
            return true;
        }
        return false;
    }

    public static BlockState getStrippedState(BlockState state) {
        BlockState strippedState;
        BlockState blockState = strippedState = AxeAccessor.isStripped(state.m_60734_()) ? state : AxeAccessor.getStripped(state);
        if (strippedState == null) {
            return ConfigHandler.inferredStrippedStates.get().getOrDefault(state.m_60734_(), state.m_60734_().m_49966_());
        }
        return strippedState;
    }
}

