/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Snake;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class SnakeModel
extends AnimatedGeoModel<Snake> {
    public ResourceLocation getModelLocation(Snake snake) {
        return new ResourceLocation("naturalist", "geo/snake.geo.json");
    }

    public ResourceLocation getTextureLocation(Snake snake) {
        if (snake.m_6095_().equals(NaturalistEntityTypes.CORAL_SNAKE.get())) {
            return new ResourceLocation("naturalist", "textures/entity/snake/coral_snake.png");
        }
        if (snake.m_6095_().equals(NaturalistEntityTypes.RATTLESNAKE.get())) {
            return new ResourceLocation("naturalist", "textures/entity/snake/rattlesnake.png");
        }
        return new ResourceLocation("naturalist", "textures/entity/snake/snake.png");
    }

    public ResourceLocation getAnimationFileLocation(Snake snake) {
        return new ResourceLocation("naturalist", "animations/snake.animation.json");
    }

    public void setLivingAnimations(Snake snake, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)snake, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone tail2 = this.getAnimationProcessor().getBone("tail2");
        IBone tail4 = this.getAnimationProcessor().getBone("tail4");
        if (!snake.m_5803_()) {
            head.setRotationX(((EntityModelData)extraDataOfType.get((int)0)).headPitch * ((float)Math.PI / 180));
            head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
        }
        if (!snake.m_21205_().m_41619_()) {
            tail2.setScaleX(1.5f);
            tail2.setScaleY(1.5f);
        }
        tail4.setHidden(!snake.m_6095_().equals(NaturalistEntityTypes.RATTLESNAKE.get()));
    }
}

