/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nethersexoticism.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.nethersexoticism.world.features.ores.BouddhasHandSpawnerFeature;
import net.mcreator.nethersexoticism.world.features.ores.JabuticabaSpawnerFeature;
import net.mcreator.nethersexoticism.world.features.ores.KiwanoSpawnerFeature;
import net.mcreator.nethersexoticism.world.features.ores.PitayaSpawnerFeature;
import net.mcreator.nethersexoticism.world.features.ores.RambutanSpawnerFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class NethersExoticismModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"nethers_exoticism");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> JABUTICABA_SPAWNER = NethersExoticismModFeatures.register("jabuticaba_spawner", JabuticabaSpawnerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, JabuticabaSpawnerFeature.GENERATE_BIOMES, JabuticabaSpawnerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> KIWANO_SPAWNER = NethersExoticismModFeatures.register("kiwano_spawner", KiwanoSpawnerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, KiwanoSpawnerFeature.GENERATE_BIOMES, KiwanoSpawnerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PITAYA_SPAWNER = NethersExoticismModFeatures.register("pitaya_spawner", PitayaSpawnerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, PitayaSpawnerFeature.GENERATE_BIOMES, PitayaSpawnerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RAMBUTAN_SPAWNER = NethersExoticismModFeatures.register("rambutan_spawner", RambutanSpawnerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RambutanSpawnerFeature.GENERATE_BIOMES, RambutanSpawnerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BOUDDHAS_HAND_SPAWNER = NethersExoticismModFeatures.register("bouddhas_hand_spawner", BouddhasHandSpawnerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BouddhasHandSpawnerFeature.GENERATE_BIOMES, BouddhasHandSpawnerFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

