/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.init;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import tech.thatgravyboat.creeperoverhaul.client.ClientConfig;
import tech.thatgravyboat.creeperoverhaul.client.renderer.normal.CreeperModel;
import tech.thatgravyboat.creeperoverhaul.client.renderer.normal.CreeperRenderer;
import tech.thatgravyboat.creeperoverhaul.client.renderer.replaced.ReplacedCreeperRenderer;
import tech.thatgravyboat.creeperoverhaul.common.entity.CreeperTypes;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModBlocks;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="creeperoverhaul", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientInit {
    private static final ResourceLocation ENERGY_SWIRL_RENDERTYPE = new ResourceLocation("creeperoverhaul", "rendertype_energy_swirl");
    private static ShaderInstance energySwirlShader;

    @SubscribeEvent
    public static void onShadersRegistered(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), ENERGY_SWIRL_RENDERTYPE, DefaultVertexFormat.f_85812_), shader -> {
            energySwirlShader = shader;
        });
    }

    @SubscribeEvent
    public static void onClient(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.JUNGLE_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.JUNGLE));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BAMBOO_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.BAMBOO));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DESERT_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.DESERT));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BADLANDS_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.BADLANDS));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.HILLS_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.HILLS));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SAVANNAH_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.SAVANNAH));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MUSHROOM_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.MUSHROOM));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SWAMP_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.SWAMP));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DRIPSTONE_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.DRIPSTONE));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.CAVE_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.CAVE));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DARK_OAK_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.DARK_OAK));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SPRUCE_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.SPRUCE));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BEACH_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.BEACH));
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SNOWY_CREEPER.get()), ClientInit.createRenderer(CreeperTypes.SNOWY));
        if (((Boolean)ClientConfig.REPLACE_DEFAULT_CREEPER.get()).equals(Boolean.TRUE)) {
            EntityRenderers.m_174036_((EntityType)EntityType.f_20558_, ReplacedCreeperRenderer::new);
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TINY_CACTUS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TINY_CACTUS_POT.get()), (RenderType)RenderType.m_110463_());
    }

    private static <E extends BaseCreeper> EntityRendererProvider<E> createRenderer(CreeperType type) {
        return manager -> new CreeperRenderer(manager, new CreeperModel(type));
    }

    public static class RenderTypes
    extends RenderType {
        private static final RenderStateShard.ShaderStateShard ENERGY_SWIRL_SHARD = new RenderStateShard.ShaderStateShard(() -> energySwirlShader);

        public RenderTypes(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        public static RenderType getSwirl(ResourceLocation location, float u, float v) {
            return RenderType.m_173215_((String)ENERGY_SWIRL_RENDERTYPE.toString(), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(ENERGY_SWIRL_SHARD).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110683_((RenderStateShard.TexturingStateShard)new RenderStateShard.OffsetTexturingStateShard(u, v)).m_110685_(f_110135_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(false));
        }

        public static RenderType getTransparentEyes(ResourceLocation resourceLocation) {
            RenderStateShard.TextureStateShard renderstateshard$texturestateshard = new RenderStateShard.TextureStateShard(resourceLocation, false, false);
            return RenderTypes.m_173215_((String)"eyes", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173073_).m_173290_((RenderStateShard.EmptyTextureStateShard)renderstateshard$texturestateshard).m_110685_(f_110139_).m_110687_(f_110115_).m_110691_(false));
        }
    }
}

