/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.damagetilt;

import com.charles445.damagetilt.TiltConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfigManager {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON_CONFIG;

    public static void loadAll() {
        CommentedFileConfig commonData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("damagetilt-common.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        commonData.load();
        COMMON_SPEC.setConfig((CommentedConfig)commonData);
    }

    public static void updateCommon() {
        TiltConfig.damageTiltEnabled = (Boolean)ModConfigManager.COMMON_CONFIG.damageTiltEnabled.get();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG = (CommonConfig)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    protected static class CommonConfig {
        protected final ForgeConfigSpec.ConfigValue<Boolean> damageTiltEnabled;

        protected CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.damageTiltEnabled = builder.comment("Whether the damage tilt effect is enabled").define("damageTiltEnabled", true);
            builder.pop();
        }
    }
}

