/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.capability;

import baguchan.earthmobsmod.EarthMobsMod;
import baguchan.earthmobsmod.registry.ModEffects;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ShadowCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private static final UUID SPEED_MODIFIER_BOOST_UUID = UUID.fromString("a4be9598-fd19-8c8b-7e3d-142defd78b7c");
    public float prevShadowX;
    public float prevShadowY;
    public float prevShadowZ;
    public float shadowX;
    public float shadowY;
    public float shadowZ;
    public float prevShadowX2;
    public float prevShadowY2;
    public float prevShadowZ2;
    public float shadowX2;
    public float shadowY2;
    public float shadowZ2;
    public float prevYBodyRot;
    public float yBodyRot;
    public float prevYBodyRot2;
    public float yBodyRot2;
    public float prevRotationPitch;
    public float xRot;
    public float prevRotationPitch2;
    public float xRot2;
    private float percentBoost;

    public void tick(LivingEntity livingEntity) {
        if (livingEntity.m_21023_(ModEffects.HYPER_SPARK)) {
            double elasticity = 0.25;
            this.prevShadowX = this.shadowX;
            this.prevShadowY = this.shadowY;
            this.prevShadowZ = this.shadowZ;
            this.prevShadowX2 = this.shadowX2;
            this.prevShadowY2 = this.shadowY2;
            this.prevShadowZ2 = this.shadowZ2;
            this.prevYBodyRot = this.yBodyRot;
            this.prevYBodyRot2 = this.yBodyRot2;
            this.yBodyRot = (float)((double)this.yBodyRot + (double)(livingEntity.f_20883_ - this.yBodyRot) * elasticity * 0.75);
            this.yBodyRot2 = (float)((double)this.yBodyRot2 + (double)(this.yBodyRot - this.yBodyRot2) * elasticity * (double)0.35f);
            this.xRot = (float)((double)this.xRot + (double)(livingEntity.m_146909_() - this.xRot) * elasticity * 0.75);
            this.xRot2 = (float)((double)this.xRot2 + (double)(this.xRot - this.xRot2) * elasticity * (double)0.35f);
            this.shadowX = (float)((double)this.shadowX + (livingEntity.m_20185_() - (double)this.shadowX) * elasticity);
            this.shadowY = (float)((double)this.shadowY + (livingEntity.m_20186_() - (double)this.shadowY) * elasticity);
            this.shadowZ = (float)((double)this.shadowZ + (livingEntity.m_20189_() - (double)this.shadowZ) * elasticity);
            this.shadowX2 = (float)((double)this.shadowX2 + (double)(this.shadowX - this.shadowX2) * elasticity * 0.375);
            this.shadowY2 = (float)((double)this.shadowY2 + (double)(this.shadowY - this.shadowY2) * elasticity * 0.375);
            this.shadowZ2 = (float)((double)this.shadowZ2 + (double)(this.shadowZ - this.shadowZ2) * elasticity * 0.375);
            if (livingEntity.m_21023_(ModEffects.HYPER_SPARK) && this.percentBoost >= 0.65f) {
                this.pushEntities(livingEntity);
            }
            this.removeBoost(livingEntity);
            this.tryAddBooster(livingEntity);
        }
    }

    protected void pushEntities(LivingEntity entity) {
        List list = entity.f_19853_.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), entity.m_142469_().m_82363_((double)0.05f, 0.0, (double)0.05f), EntitySelector.m_20421_((Entity)entity));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                LivingEntity entity2 = (LivingEntity)list.get(l);
                if (entity == entity2) continue;
                entity2.m_147240_(2.0 * (double)this.percentBoost, entity2.m_20185_() - entity.m_20185_(), entity2.m_20189_() - entity.m_20189_());
                entity2.m_6469_(DamageSource.m_19370_((LivingEntity)entity), (float)Mth.m_14143_((float)(8.0f * this.percentBoost)));
            }
        }
    }

    protected void removeBoost(LivingEntity entity) {
        AttributeInstance attributeinstance = entity.m_21051_(Attributes.f_22279_);
        if (attributeinstance != null && attributeinstance.m_22111_(SPEED_MODIFIER_BOOST_UUID) != null) {
            attributeinstance.m_22120_(SPEED_MODIFIER_BOOST_UUID);
        }
    }

    protected void tryAddBooster(LivingEntity entity) {
        this.percentBoost = entity.m_20142_() && entity.m_21023_(ModEffects.HYPER_SPARK) ? (this.percentBoost <= 1.0f ? (this.percentBoost += 0.01f) : 1.0f) : (this.percentBoost >= 0.0f ? (this.percentBoost -= 0.1f) : 0.0f);
        if (this.percentBoost > 0.0f) {
            AttributeInstance attributeinstance = entity.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) {
                return;
            }
            float f = 0.15f * this.percentBoost;
            attributeinstance.m_22118_(new AttributeModifier(SPEED_MODIFIER_BOOST_UUID, "Spark Boost", (double)f, AttributeModifier.Operation.ADDITION));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("PercentBoost", this.percentBoost);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.percentBoost = nbt.m_128457_("PercentBoost");
    }

    public float getPercentBoost() {
        return this.percentBoost;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == EarthMobsMod.SHADOW_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }
}

