/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.blocks.charred.CharredBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.mixins.accessors.BiomeAccessor;
import com.ordana.immersive_weathering.reg.LeafPilesRegistry;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WeatheringHelper {
    public static final Supplier<BiMap<Block, Block>> FLOWERY_BLOCKS = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_152542_, (Object)Blocks.f_152541_).put((Object)Blocks.f_152471_, (Object)Blocks.f_152470_).put((Object)((Block)ModBlocks.FLOWERING_AZALEA_LEAF_PILE.get()), (Object)((Block)ModBlocks.AZALEA_LEAF_PILE.get()));
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:flowering_azalea_hedge", "quark:azalea_hedge");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:flowering_azalea_leaf_carpet", "quark:azalea_leaf_carpet");
        return builder.build();
    });
    public static final Supplier<Map<Block, ParticleOptions>> BARK_PARTICLES = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)Blocks.f_49999_, (Object)((ParticleOptions)ModParticles.OAK_BARK.get())).put((Object)Blocks.f_50004_, (Object)((ParticleOptions)ModParticles.DARK_OAK_BARK.get())).put((Object)Blocks.f_50000_, (Object)((ParticleOptions)ModParticles.SPRUCE_BARK.get())).put((Object)Blocks.f_50001_, (Object)((ParticleOptions)ModParticles.BIRCH_BARK.get())).put((Object)Blocks.f_50002_, (Object)((ParticleOptions)ModParticles.JUNGLE_BARK.get())).put((Object)Blocks.f_50003_, (Object)((ParticleOptions)ModParticles.ACACIA_BARK.get())).put((Object)Blocks.f_50695_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).put((Object)Blocks.f_50686_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).put((Object)Blocks.f_50011_, (Object)((ParticleOptions)ModParticles.OAK_BARK.get())).put((Object)Blocks.f_50043_, (Object)((ParticleOptions)ModParticles.DARK_OAK_BARK.get())).put((Object)Blocks.f_50012_, (Object)((ParticleOptions)ModParticles.SPRUCE_BARK.get())).put((Object)Blocks.f_50013_, (Object)((ParticleOptions)ModParticles.BIRCH_BARK.get())).put((Object)Blocks.f_50014_, (Object)((ParticleOptions)ModParticles.JUNGLE_BARK.get())).put((Object)Blocks.f_50015_, (Object)((ParticleOptions)ModParticles.ACACIA_BARK.get())).put((Object)Blocks.f_50697_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).put((Object)Blocks.f_50688_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).build());

    public static void addOptional(ImmutableBiMap.Builder<Block, Block> map, String moddedId, String moddedId2) {
        Optional o1 = Registry.f_122824_.m_6612_(new ResourceLocation(moddedId));
        Optional o2 = Registry.f_122824_.m_6612_(new ResourceLocation(moddedId2));
        if (o1.isPresent() && o2.isPresent()) {
            map.put((Object)((Block)o1.get()), (Object)((Block)o2.get()));
        }
    }

    public static Optional<BlockState> getAzaleaGrowth(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().inverse().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getAzaleaSheared(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Item getBarkToStrip(BlockState normalLog) {
        for (Pair<Item, Block> e : LeafPilesRegistry.STRIPPED_LOG_TO_BARK.get().values()) {
            if (e.getSecond() != normalLog.m_60734_()) continue;
            return (Item)e.getFirst();
        }
        return null;
    }

    public static Optional<Pair<Item, Block>> getBarkForStrippedLog(BlockState normalLog) {
        Optional<Pair<Item, Block>> pair = Optional.ofNullable(LeafPilesRegistry.STRIPPED_LOG_TO_BARK.get().get(normalLog.m_60734_()));
        if (pair.isPresent()) {
            ResourceLocation res;
            Optional bark;
            String s = CommonConfigs.GENERIC_BARK.get();
            if (!s.isEmpty() && (bark = Registry.f_122827_.m_6612_(res = new ResourceLocation(s))).isPresent()) {
                return Optional.of(Pair.of((Object)((Item)bark.get()), (Object)((Block)pair.get().getSecond())));
            }
            return pair;
        }
        return Optional.empty();
    }

    public static Optional<ParticleOptions> getBarkParticle(BlockState state) {
        return Optional.ofNullable(BARK_PARTICLES.get().get(state.m_60734_()));
    }

    public static List<BlockPos> grabBlocksAroundRandomly(BlockPos centerPos, int radiusX, int radiusY, int radiusZ) {
        List<BlockPos> list = BlockPos.m_121985_((BlockPos)centerPos, (int)radiusX, (int)radiusY, (int)radiusZ).map(BlockPos::new).collect(Collectors.toList());
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        return list;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radiusX, int radiusY, int radiusZ, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        List<BlockPos> lis = WeatheringHelper.grabBlocksAroundRandomly(centerPos, radiusX, radiusY, radiusZ);
        int count = 0;
        for (BlockPos pos : lis) {
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radius, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        return WeatheringHelper.hasEnoughBlocksAround(centerPos, radius, radius, radius, level, blockPredicate, requiredAmount);
    }

    public static boolean hasEnoughBlocksFacingMe(BlockPos centerPos, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        int count = 0;
        ArrayList<Direction> list = new ArrayList<Direction>(List.of(Direction.values()));
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        for (Direction dir : list) {
            BlockPos pos = centerPos.m_142300_(dir);
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) && (!state.m_61138_((Property)RotatedPillarBlock.f_55923_) || state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) && !Registry.f_122824_.m_7981_((Object)state.m_60734_()).m_135815_().contains("stripped");
    }

    public static boolean isIciclePos(BlockPos pos) {
        int rarity = CommonConfigs.ICICLE_RARITY.get();
        if (rarity == 1001) {
            return false;
        }
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        return posRandom.nextInt(rarity) == 0;
    }

    public static void onFireExpired(ServerLevel serverLevel, BlockPos pos, BlockState state) {
    }

    public static void onFireBurnBlock(Level level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WeatheringHelper.tryCharBlock(serverLevel, pos, state);
        }
    }

    public static boolean tryCharBlock(ServerLevel world, BlockPos pos, BlockState state) {
        double charChance = CommonConfigs.FIRE_CHARS_WOOD_CHANCE.get();
        double ashChance = CommonConfigs.ASH_SPAWNS_CHANCE.get();
        if (charChance != 0.0 || ashChance != 0.0) {
            BlockState charred;
            BlockState newState = null;
            BlockState blockState = charred = charChance != 0.0 ? WeatheringHelper.getCharredState(state) : null;
            if (charred != null && (double)world.f_46441_.nextFloat() < charChance) {
                newState = (BlockState)charred.m_61124_((Property)CharredBlock.SMOLDERING, (Comparable)Boolean.valueOf(world.f_46441_.nextBoolean()));
            }
            if (charred == null && (double)world.f_46441_.nextFloat() < ashChance) {
                newState = ModBlocks.ASH_LAYER_BLOCK.get().m_49966_();
            }
            if (newState != null) {
                world.m_8767_((ParticleOptions)ModParticles.SOOT.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
                return world.m_7731_(pos, newState, 3);
            }
        }
        return false;
    }

    @Nullable
    public static BlockState getCharredState(BlockState state) {
        Block charred = null;
        if (state.m_204336_(BlockTags.f_13098_)) {
            charred = ModBlocks.CHARRED_FENCE.get();
        } else if (state.m_204336_(BlockTags.f_13055_)) {
            charred = ModBlocks.CHARRED_FENCE_GATE.get();
        } else if (state.m_204336_(BlockTags.f_13097_)) {
            charred = ModBlocks.CHARRED_SLAB.get();
        } else if (state.m_204336_(BlockTags.f_13096_)) {
            charred = ModBlocks.CHARRED_STAIRS.get();
        } else if (state.m_204336_(BlockTags.f_13090_)) {
            charred = ModBlocks.CHARRED_PLANKS.get();
        } else if (state.m_204336_(BlockTags.f_13105_)) {
            charred = ModBlocks.CHARRED_LOG.get();
        }
        if (charred == null) {
            return null;
        }
        return charred.m_152465_(state);
    }

    public boolean ashStuff(BlockState state, Level level, BlockPos pos) {
        BlockState downState = level.m_8055_(pos.m_7495_());
        if (!(level.f_46441_.nextFloat() > 0.2f) && downState.m_60713_(Blocks.f_50440_)) {
            return level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 3);
        }
        return false;
    }

    public static float getTemp(Level level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        return ((BiomeAccessor)biome).invokeGetTemperature(pos);
    }

    public static boolean isPosWet(Level level, Holder<Biome> biome, BlockPos pos) {
        return biome.m_203656_(ModTags.WET);
    }

    public static boolean isPosHot(Level level, Holder<Biome> biome, BlockPos pos) {
        return biome.m_203656_(ModTags.HOT);
    }

    public static boolean shouldGetWet(ServerLevel world, BlockPos pos) {
        int temperature = 0;
        boolean isTouchingWater = false;
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_142300_(direction);
            Holder biome = world.m_204166_(pos);
            BlockState neighborState = world.m_8055_(targetPos);
            if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                isTouchingWater = true;
                break;
            }
            if (world.m_46758_(pos.m_142300_(direction))) {
                --temperature;
                continue;
            }
            if (neighborState.m_204336_(ModTags.MAGMA_SOURCE) || world.m_6042_().m_63951_()) {
                ++temperature;
                continue;
            }
            if (WeatheringHelper.isPosWet((Level)world, (Holder<Biome>)biome, pos)) {
                --temperature;
                continue;
            }
            if (!WeatheringHelper.isPosHot((Level)world, (Holder<Biome>)biome, pos)) continue;
            ++temperature;
        }
        return temperature < 0 || isTouchingWater;
    }

    public static void applyFreezing(Entity entity, int freezingIncrement) {
        WeatheringHelper.applyFreezing(entity, freezingIncrement, false);
    }

    public static void applyFreezing(Entity entity, int freezingIncrement, boolean inWater) {
        LivingEntity le;
        if (entity instanceof Player) {
            boolean bl = true;
        }
        if (freezingIncrement != 0 && entity.m_142079_() && entity instanceof LivingEntity && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44974_, (LivingEntity)(le = (LivingEntity)entity)) <= 0 && !entity.m_6095_().m_204039_(ModTags.LIGHT_FREEZE_IMMUNE)) {
            if (inWater ? le.m_6844_(EquipmentSlot.FEET).m_150930_(Items.f_42463_) : le.m_21023_(MobEffects.f_19592_)) {
                return;
            }
            entity.m_146917_(Math.min(entity.m_146891_(), entity.m_146888_() + freezingIncrement));
        }
    }

    public static void growHangingRoots(ServerLevel world, Random random, BlockPos pos) {
        BlockState newState;
        Direction dir = Direction.values()[1 + random.nextInt(5)].m_122424_();
        BlockPos targetPos = pos.m_142300_(dir);
        BlockState targetState = world.m_8055_(targetPos);
        if (targetState.m_60795_()) {
            return;
        }
        BlockState blockState = newState = dir == Direction.DOWN ? Blocks.f_152548_.m_49966_() : (BlockState)ModBlocks.HANGING_ROOTS_WALL.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir);
        if (targetState.m_60713_(Blocks.f_49990_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        world.m_46597_(targetPos, newState);
    }
}

