/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.charred;

import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public interface Charred
extends ILightable,
Fallable {
    public static final BooleanProperty SMOLDERING = ModBlockProperties.SMOLDERING;
    public static final IntegerProperty OVERHANG = ModBlockProperties.OVERHANG;

    default public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        int temperature = 0;
        boolean isTouchingWater = false;
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_142300_(direction);
            Holder biome = world.m_204166_(pos);
            BlockState neighborState = world.m_8055_(targetPos);
            if (world.m_46758_(pos.m_142300_(direction)) || neighborState.m_60819_().m_76152_() == Fluids.f_76192_ || neighborState.m_60819_().m_76152_() == Fluids.f_76193_) {
                isTouchingWater = true;
            }
            if (world.m_46758_(pos.m_142300_(direction)) || biome.m_203656_(ModTags.WET) || neighborState.m_60819_().m_76152_() == Fluids.f_76192_ || neighborState.m_60819_().m_76152_() == Fluids.f_76193_) {
                --temperature;
                continue;
            }
            if (!neighborState.m_204336_(ModTags.MAGMA_SOURCE) && !neighborState.m_204336_(BlockTags.f_13076_)) continue;
            ++temperature;
        }
        if (temperature < 0 || isTouchingWater) {
            if (this.isLit(state)) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.valueOf(false)));
            }
        } else if (temperature > 0 && !((Boolean)state.m_61143_((Property)SMOLDERING)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.valueOf(true)));
        }
    }

    default public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (random.nextInt(16) == 0 && FallingBlock.m_53241_((BlockState)world.m_8055_(pos.m_7495_()))) {
            double d = (double)pos.m_123341_() + random.nextDouble();
            double e = (double)pos.m_123342_() - 0.05;
            double f = (double)pos.m_123343_() + random.nextDouble();
            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), d, e, f, 0.0, 0.0, 0.0);
        }
        if (this.isLit(state)) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            double d = (double)i + random.nextDouble();
            double e = (double)j + random.nextDouble();
            double f = (double)k + random.nextDouble();
            world.m_7106_((ParticleOptions)ModParticles.EMBERSPARK.get(), d, e, f, 0.1, 3.0, 0.1);
        }
    }

    default public void onEntityStepOn(BlockState state, Entity entity) {
        if (this.isLit(state) && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(DamageSource.f_19309_, 1.0f);
        }
    }

    @Override
    default public boolean isLit(BlockState state) {
        return (Boolean)state.m_61143_((Property)SMOLDERING);
    }

    @Override
    default public BlockState toggleLitState(BlockState state, boolean lit) {
        return (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.valueOf(lit));
    }

    default public int getOverhang(Level level, BlockPos pos) {
        int overhang = 2;
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN) {
                boolean free;
                boolean bl = free = FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_();
                if (free) continue;
                overhang = 0;
                break;
            }
            if (dir == Direction.UP) continue;
            BlockPos neighborPos = pos.m_142300_(dir);
            BlockState neighbor = level.m_8055_(neighborPos);
            if (neighbor.m_61138_((Property)OVERHANG)) {
                if ((Integer)neighbor.m_61143_((Property)OVERHANG) != 0) continue;
                overhang = 1;
                break;
            }
            if (!neighbor.m_60783_((BlockGetter)level, neighborPos, dir.m_122424_())) continue;
            overhang = 1;
            break;
        }
        return overhang;
    }

    default public void updateOverhang(BlockState state, Level level, BlockPos pos) {
        int supported = this.getOverhang(level, pos);
        if (supported != (Integer)state.m_61143_((Property)OVERHANG)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)OVERHANG, (Comparable)Integer.valueOf(supported)));
        }
        if (supported == 2) {
            level.m_186460_(pos, state.m_60734_(), 1);
        }
    }

    default public void m_142216_(Level level, BlockPos pos, BlockState blockState, BlockState blockState2, FallingBlockEntity fallingBlock) {
    }
}

