/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.frostable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public interface Frosty {
    public static final Supplier<BiMap<Block, Block>> UNFROSTY_TO_FROSTY = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_50016_, (Object)ModBlocks.FROST.get()).put((Object)Blocks.f_50058_, (Object)ModBlocks.FROSTY_GLASS.get()).put((Object)Blocks.f_50035_, (Object)ModBlocks.FROSTY_FERN.get()).put((Object)Blocks.f_50034_, (Object)ModBlocks.FROSTY_GRASS.get()).put((Object)Blocks.f_50185_, (Object)ModBlocks.FROSTY_GLASS_PANE.get());
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> FROSTY_TO_UNFROSTY = Suppliers.memoize(() -> UNFROSTY_TO_FROSTY.get().inverse());
    public static final BooleanProperty NATURAL = BooleanProperty.m_61465_((String)"natural");

    default public Optional<BlockState> getFrosty(BlockState state) {
        return Frosty.getFrosty(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public Optional<BlockState> getUnfrosty(BlockState state) {
        return Frosty.getUnfrosty(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getUnfrosty(Block block) {
        return Optional.ofNullable((Block)FROSTY_TO_UNFROSTY.get().get((Object)block));
    }

    public static Optional<Block> getFrosty(Block block) {
        return Optional.ofNullable((Block)UNFROSTY_TO_FROSTY.get().get((Object)block));
    }

    default public void tryUnFrost(BlockState state, ServerLevel world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)NATURAL)).booleanValue() && (world.m_6042_().m_63951_() || !world.m_46471_() && world.m_46461_() || world.m_45517_(LightLayer.BLOCK, pos) > 7 - state.m_60739_((BlockGetter)world, pos))) {
            world.m_46597_(pos, this.getUnfrosty(state).get());
        }
    }

    default public InteractionResult interactWithPlayer(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof FlintAndSteelItem) {
            level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123762_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                level.m_46597_(pos, this.getUnfrosty(state).get());
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

