/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil;

import com.ordana.immersive_weathering.blocks.soil.SoilBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.IConditionalGrowingBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.phys.BlockHitResult;

public class ModMyceliumBlock
extends MyceliumBlock
implements BonemealableBlock,
IConditionalGrowingBlock {
    public static final BooleanProperty FERTILE = SoilBlock.FERTILE;

    public ModMyceliumBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FERTILE});
    }

    public boolean m_6724_(BlockState state) {
        return SoilBlock.isFertile(state) && super.m_6724_(state);
    }

    @Override
    public boolean canGrow(BlockState state) {
        return SoilBlock.isFertile(state);
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return !SoilBlock.isFertile(state) && level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_5491_(Level p_50901_, Random p_50902_, BlockPos p_50903_, BlockState p_50904_) {
        return true;
    }

    public void m_7719_(ServerLevel level, Random random, BlockPos pos, BlockState state) {
        if (!SoilBlock.isFertile(state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack;
        if (SoilBlock.isFertile(state) && (itemstack = player.m_21120_(hand)).m_41720_() instanceof ShearsItem) {
            if (!level.f_46443_) {
                level.m_5594_(null, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(false)), 11);
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
            } else {
                level.m_142052_(pos, Blocks.f_50072_.m_49966_());
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    private static boolean canBeGrass(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = levelReader.m_8055_(blockPos);
        if (blockState.m_60713_(Blocks.f_50125_) && (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockState.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)levelReader, (BlockState)state, (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.m_60739_((BlockGetter)levelReader, blockPos));
        return i < levelReader.m_7469_();
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        return ModMyceliumBlock.canBeGrass(state, level, pos) && !level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (!ModMyceliumBlock.canBeGrass(state, (LevelReader)level, pos)) {
            level.m_46597_(pos, Blocks.f_50493_.m_49966_());
        } else if (level.m_46803_(pos.m_7494_()) >= 9) {
            BlockState blockState = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if ((level.m_8055_(blockPos).m_60713_(Blocks.f_50493_) || CommonConfigs.MYCELIUM_OVER_GRASS.get().booleanValue() && level.m_8055_(blockPos).m_60713_(Blocks.f_50440_)) && ModMyceliumBlock.canPropagate(blockState, (LevelReader)level, blockPos)) {
                    level.m_46597_(blockPos, (BlockState)this.m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
                    continue;
                }
                if (!level.m_8055_(blockPos).m_60713_(Blocks.f_152549_) || !ModMyceliumBlock.canPropagate(blockState, (LevelReader)level, blockPos)) continue;
                level.m_46597_(blockPos, (BlockState)Blocks.f_50195_.m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
            }
        }
    }
}

