/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil;

import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MulchBlock
extends FarmBlock {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;

    public MulchBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return super.m_5573_(ctx);
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!this.isSoaked(state) || random.nextInt(25) != 1 || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP))) {
            double d0 = (double)pos.m_123341_() + random.nextDouble();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + random.nextDouble();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockState cropState = world.m_8055_(pos.m_7494_());
        if (CommonConfigs.MULCH_GROWS_CROPS.get().booleanValue() && (Integer)state.m_61143_((Property)MOISTURE) == 7 && world.m_45524_(pos.m_7494_(), 0) >= 9) {
            int j;
            if (cropState.m_60734_() instanceof BeetrootBlock) {
                return;
            }
            if (cropState.m_60734_() instanceof CropBlock && (j = ((Integer)cropState.m_61143_((Property)CropBlock.f_52244_)).intValue()) < 7) {
                world.m_7731_(pos.m_7494_(), (BlockState)cropState.m_60734_().m_152465_(cropState).m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(j + 1)), 3);
            }
        }
        int temperature = 0;
        boolean isTouchingWater = false;
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_142300_(direction);
            Holder biome = world.m_204166_(pos);
            BlockState neighborState = world.m_8055_(targetPos);
            if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                isTouchingWater = true;
            }
            if (world.m_46758_(pos.m_142300_(direction)) || biome.m_203656_(ModTags.WET) || neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                --temperature;
                continue;
            }
            if (!neighborState.m_204336_(ModTags.MAGMA_SOURCE) && !biome.m_203656_(ModTags.HOT) && world.m_46472_() != Level.f_46429_) continue;
            ++temperature;
        }
        if (temperature < 0 || isTouchingWater) {
            if ((Integer)state.m_61143_((Property)MOISTURE) == 0) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)));
            }
        } else if (temperature > 0 && this.isSoaked(state)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
        }
    }

    private boolean isSoaked(BlockState state) {
        return (Integer)state.m_61143_((Property)MOISTURE) == 7;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance, 0.2f, DamageSource.f_19315_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{MOISTURE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_36341_()) {
            if (player.m_21120_(hand).m_150930_(Items.f_42447_) && !this.isSoaked(state)) {
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)));
                level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123769_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_150930_(Items.f_42446_) && this.isSoaked(state)) {
                if (!player.m_7500_()) {
                    ItemStack stack = player.m_21120_(hand);
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42447_.m_7968_());
                    player.m_21008_(hand, itemStack2);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
                level.m_5594_(player, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123769_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }
}

