/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil;

import com.ordana.immersive_weathering.WeatheringHelper;
import com.ordana.immersive_weathering.blocks.soil.ModGrassBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.IConditionalGrowingBlock;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LayerLightEngine;

public class RootedGrassBlock
extends ModGrassBlock
implements BonemealableBlock,
IConditionalGrowingBlock {
    public RootedGrassBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return true;
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level world, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        WeatheringHelper.growHangingRoots(world, random, pos);
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = Blocks.f_50034_.m_49966_();
        world.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true)));
        block0: for (int i = 0; i < 128; ++i) {
            Holder registryEntry;
            BlockPos blockPos2 = blockPos;
            for (int j = 0; j < i / 16; ++j) {
                if (!world.m_8055_((blockPos2 = blockPos2.m_142082_(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).m_7495_()).m_60713_((Block)this) || world.m_8055_(blockPos2).m_60838_((BlockGetter)world, blockPos2)) continue block0;
            }
            BlockState blockState2 = world.m_8055_(blockPos2);
            if (blockState2.m_60713_(blockState.m_60734_()) && random.nextInt(10) == 0) {
                ((BonemealableBlock)blockState.m_60734_()).m_7719_(world, random, blockPos2, blockState2);
            }
            if (!blockState2.m_60795_()) continue;
            if (random.nextInt(8) == 0) {
                List list = ((Biome)world.m_204166_(blockPos2).m_203334_()).m_47536_().m_47815_();
                if (list.isEmpty()) continue;
                registryEntry = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_();
            } else {
                registryEntry = VegetationPlacements.f_195459_;
            }
            ((PlacedFeature)registryEntry.m_203334_()).m_191782_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, blockPos2);
        }
    }

    private static boolean canPropagate(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        return RootedGrassBlock.canBeGrass(state, world, pos) && !world.m_6425_(blockPos).m_205070_(FluidTags.f_13131_);
    }

    private static boolean canBeGrass(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60713_(Blocks.f_50125_) && (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockState.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.m_60739_((BlockGetter)world, blockPos));
        return i < world.m_7469_();
    }

    @Override
    public boolean canGrow(BlockState state) {
        return (Boolean)state.m_61143_((Property)FERTILE);
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if ((Integer)state.m_61143_((Property)AGE) == 10) {
            level.m_46597_(pos, Blocks.f_152481_.m_49966_());
        }
        if ((Integer)state.m_61143_((Property)AGE) < 10 && (Integer)state.m_61143_((Property)AGE) > 1) {
            int j = (Integer)state.m_61143_((Property)AGE);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j - 1)), 3);
        }
        if (!RootedGrassBlock.canBeGrass(state, (LevelReader)level, pos)) {
            level.m_46597_(pos, Blocks.f_152549_.m_49966_());
        } else if (level.m_46803_(pos.m_7494_()) >= 9) {
            BlockState blockState = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if ((level.m_8055_(blockPos).m_60713_(Blocks.f_50493_) || CommonConfigs.GRASS_OVER_MYCELIUM.get().booleanValue() && level.m_8055_(blockPos).m_60713_(Blocks.f_50195_)) && RootedGrassBlock.canPropagate(blockState, (LevelReader)level, blockPos)) {
                    level.m_46597_(blockPos, (BlockState)Blocks.f_50440_.m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
                    continue;
                }
                if (!level.m_8055_(blockPos).m_60713_(Blocks.f_152549_) || !RootedGrassBlock.canPropagate(blockState, (LevelReader)level, blockPos)) continue;
                level.m_46597_(blockPos, (BlockState)ModBlocks.ROOTED_GRASS_BLOCK.get().m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
            }
        }
    }
}

