/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.WeatheringHelper;
import com.ordana.immersive_weathering.blocks.IcicleBlock;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.mixins.accessors.IceInvoker;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class IceGrowth
extends BuiltinBlockGrowth {
    public IceGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources) {
        super(name, owners, sources);
    }

    public static void tryPlacingIcicle(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW && WeatheringHelper.isIciclePos(pos)) {
            BlockPos p = pos.m_6625_(state.m_204336_(BlockTags.f_144279_) ? 2 : 1);
            BlockState placement = (BlockState)ModBlocks.ICICLE.get().m_49966_().m_61124_((Property)IcicleBlock.f_154009_, (Comparable)Direction.DOWN);
            if (level.m_8055_(p).m_60795_() && placement.m_60710_((LevelReader)level, p) && Direction.Plane.HORIZONTAL.m_122557_().anyMatch(d -> {
                BlockPos rel = p.m_142300_(d);
                return level.m_45527_(rel) && level.m_8055_(rel).m_60795_();
            })) {
                level.m_46597_(p, placement);
            }
        }
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Holder<Biome> b) {
        Block block;
        BlockPos icePos;
        Biome biome = (Biome)b.m_203334_();
        Random random = level.f_46441_;
        if (random.nextFloat() < 0.003f && level.m_8055_(icePos = pos.m_7495_()).m_60713_(Blocks.f_50016_) && biome.m_198904_(pos) && (level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_) || level.m_46461_() && !level.m_46471_() && !level.m_46470_())) {
            level.m_46597_(icePos, (BlockState)((BlockState)ModBlocks.ICICLE.get().m_49966_().m_61124_((Property)BlockStateProperties.f_155997_, (Comparable)Direction.DOWN)).m_61124_((Property)IcicleBlock.f_154010_, (Comparable)DripstoneThickness.TIP));
        }
        if ((block = state.m_60734_()) instanceof IceInvoker) {
            IceInvoker ice = (IceInvoker)block;
            if (level.m_6042_().m_63951_()) {
                level.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 2.9f + (random.nextFloat() - random.nextFloat()) * 0.6f);
                float i = (float)pos.m_123341_() + 0.5f;
                float j = (float)pos.m_123342_() + 0.5f;
                float k = (float)pos.m_123343_() + 0.5f;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)i, (double)j, (double)k, 12, 0.2, 0.2, 0.2, 0.0);
                ice.invokeMelt(state, (Level)level, pos);
            } else if (biome.m_198910_(pos) && level.m_46461_()) {
                ice.invokeMelt(state, (Level)level, pos);
            }
        }
    }
}

