/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.WeatheringHelper;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.ClientConfigs;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.network.NetworkHandler;
import com.ordana.immersive_weathering.network.SendCustomParticlesPacket;
import com.ordana.immersive_weathering.reg.LeafPilesRegistry;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class LeavesGrowth
extends BuiltinBlockGrowth {
    public LeavesGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources) {
        super(name, owners, sources);
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Holder<Biome> biome) {
        Block leafPile;
        Random random = level.f_46441_;
        if ((!state.m_61138_((Property)LeavesBlock.f_54419_) || !((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) && random.nextFloat() < (float)CommonConfigs.LEAF_PILES_REACH.get().intValue() && (leafPile = (Block)LeafPilesRegistry.getFallenLeafPile(state).orElse(null)) != null && level.m_8055_(pos.m_7495_()).m_60795_()) {
            if (random.nextBoolean() && WeatheringHelper.isIciclePos(pos) && ((Biome)level.m_204166_(pos).m_203334_()).m_198904_(pos)) {
                level.m_7731_(pos.m_7495_(), (BlockState)ModBlocks.ICICLE.get().m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)Direction.DOWN), 2);
            }
            if (!PlatformHelper.isAreaLoaded((LevelReader)level, pos, 2)) {
                return;
            }
            BlockPos targetPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            int maxFallenLeavesReach = CommonConfigs.LEAF_PILES_REACH.get();
            int maxPileHeight = CommonConfigs.LEAF_PILE_MAX_HEIGHT.get();
            int dist = pos.m_123342_() - targetPos.m_123342_();
            if (dist < 0) {
                targetPos = pos;
                do {
                    targetPos = targetPos.m_7495_();
                    dist = pos.m_123342_() - targetPos.m_123342_();
                } while (level.m_8055_(targetPos).m_60767_().m_76336_() && dist < maxFallenLeavesReach);
                targetPos = targetPos.m_7494_();
            }
            if (dist < maxFallenLeavesReach) {
                BlockState replaceState = level.m_8055_(targetPos);
                BlockState groundState = level.m_8055_(targetPos.m_7495_());
                boolean isOnLeaf = replaceState.m_60734_() instanceof LeafPileBlock;
                int pileHeight = 1;
                if (isOnLeaf && ((pileHeight = ((Integer)replaceState.m_61143_((Property)LeafPileBlock.LAYERS)).intValue()) == 0 || pileHeight >= maxPileHeight)) {
                    return;
                }
                BlockState baseLeaf = (BlockState)leafPile.m_49966_().m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(0));
                if (isOnLeaf || groundState.m_60783_((BlockGetter)level, targetPos.m_7495_(), Direction.UP) && replaceState.m_60767_().m_76336_() && baseLeaf.m_60710_((LevelReader)level, targetPos) && !WeatheringHelper.hasEnoughBlocksAround(targetPos, 2, 2, 2, (Level)level, b -> b.m_60734_() instanceof LeafPileBlock, 6)) {
                    if (level.m_8055_(targetPos.m_7495_()).m_60713_(Blocks.f_49990_)) {
                        level.m_7731_(targetPos, (BlockState)baseLeaf.m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(0)), 2);
                    } else {
                        if (isOnLeaf) {
                            int original = pileHeight;
                            boolean hasLog = false;
                            BlockState[] neighbors = new BlockState[4];
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                neighbors[direction.m_122416_()] = level.m_8055_(targetPos.m_142300_(direction));
                            }
                            for (BlockState neighbor : neighbors) {
                                if (!WeatheringHelper.isLog(neighbor)) continue;
                                hasLog = true;
                                break;
                            }
                            for (BlockState neighbor : neighbors) {
                                int i;
                                if (!(neighbor.m_60734_() instanceof LeafPileBlock)) continue;
                                int n = i = hasLog ? maxPileHeight : Math.min((Integer)neighbor.m_61143_((Property)LeafPileBlock.LAYERS) - 1, maxPileHeight);
                                if (i <= pileHeight) continue;
                                pileHeight = Math.min(pileHeight + 1, i);
                                break;
                            }
                            if (pileHeight == original) {
                                return;
                            }
                        }
                        level.m_7731_(targetPos, (BlockState)baseLeaf.m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(pileHeight)), 2);
                    }
                }
            }
        }
    }

    public static void spawnFallingLeavesParticle(BlockState state, Level level, BlockPos pos, Random random) {
        if (!(state.m_60734_() instanceof LeavesBlock)) {
            ImmersiveWeathering.LOGGER.error("Some mod tried to call leaves random tick without passing a leaf block blockstate as expected. This should be fixed on their end. Given blockstate : {}", (Object)state);
            return;
        }
        if (ClientConfigs.FALLING_LEAF_PARTICLES.get().booleanValue() && !((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue() && state.m_61138_((Property)LeavesBlock.f_54419_)) {
            SimpleParticleType leafParticle = LeafPilesRegistry.getFallenLeafParticle(state).orElse(null);
            if (leafParticle == null) {
                return;
            }
            int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
            BlockPos blockPos = pos.m_7495_();
            BlockState blockState = level.m_8055_(blockPos);
            float rate = 0.08f;
            if (!blockState.m_60815_() || !blockState.m_60838_((BlockGetter)level, blockPos)) {
                if (level.m_46471_()) {
                    rate = 0.4f;
                }
                if (random.nextFloat() < rate) {
                    double d = (double)pos.m_123341_() + random.nextDouble();
                    double e = (double)pos.m_123342_() - 0.05;
                    double f = (double)pos.m_123343_() + random.nextDouble();
                    level.m_7106_((ParticleOptions)leafParticle, d, e, f, 0.0, (double)color, 0.0);
                }
            }
        }
    }

    public static void decayLeavesPile(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos downPos;
        BlockState downState;
        if (CommonConfigs.LEAF_PILES_FROM_DECAY_CHANCE.get() > (double)level.f_46441_.nextFloat()) {
            Block leafPile = LeafPilesRegistry.getFallenLeafPile(state).orElse(null);
            if (leafPile == null) {
                return;
            }
            BlockState baseLeaf = leafPile.m_49966_();
            level.m_7731_(pos, (BlockState)baseLeaf.m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(Mth.m_144928_((Random)level.f_46441_, (int)1, (int)5))), 2);
        }
        if (!(downState = level.m_8055_(downPos = pos.m_7495_())).m_60815_() || !downState.m_60783_((BlockGetter)level, downPos, Direction.UP)) {
            NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((Level)level, pos, 32.0, new SendCustomParticlesPacket(SendCustomParticlesPacket.EventType.DECAY_LEAVES, pos, Block.m_49956_((BlockState)state)));
        }
    }
}

