/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.events;

import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.WeatheringHelper;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.blocks.mossable.Mossable;
import com.ordana.immersive_weathering.blocks.rustable.Rustable;
import com.ordana.immersive_weathering.blocks.soil.MulchBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.integration.IntegrationHandler;
import com.ordana.immersive_weathering.integration.QuarkPlugin;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModSoundEvents;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ModEvents {
    private static final List<InteractionEvent> EVENTS = new ArrayList<InteractionEvent>();

    public static InteractionResult onBlockCLicked(ItemStack stack, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        Item i = stack.m_41720_();
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        for (InteractionEvent event : EVENTS) {
            InteractionResult result = event.run(i, stack, pos, state, player, level, hand, hitResult);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult rustSponging(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        Rustable rustable;
        Optional<BlockState> rusted;
        Block block;
        if (item == Items.f_41903_ && CommonConfigs.SPONGE_RUSTING.get().booleanValue() && (block = state.m_60734_()) instanceof Rustable && (rusted = (rustable = (Rustable)block).m_142123_(state)).isPresent()) {
            level.m_5594_(player, pos, SoundEvents.f_12537_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.SCRAPE_RUST.get()), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123769_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (CommonConfigs.SPONGE_RUST_DRYING.get().booleanValue()) {
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_41902_.m_7968_());
                    player.m_21008_(hand, itemStack2);
                }
                CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, stack);
                level.m_46597_(pos, rusted.get());
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult rustScraping(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        Block block;
        if (CommonConfigs.AXE_SCRAPING.get().booleanValue() && (block = state.m_60734_()) instanceof Rustable) {
            Rustable rustable = (Rustable)block;
            Rustable.RustLevel rustLevel = (Rustable.RustLevel)rustable.m_142297_();
            if (item instanceof AxeItem) {
                if (!rustLevel.canScrape()) {
                    level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5594_(player, pos, SoundEvents.f_12347_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.SCRAPE_RUST.get()), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                    ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123762_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                    if (player instanceof ServerPlayer) {
                        stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                        CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (rustLevel != Rustable.RustLevel.UNAFFECTED) {
                    ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.SCRAPE_RUST.get()), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                    level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                        level.m_46597_(pos, rustable.getPrevious(state).get());
                        CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, stack);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else if (item == ModItems.STEEL_WOOL.get() && rustLevel != Rustable.RustLevel.UNAFFECTED) {
                level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.SCRAPE_RUST.get()), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    level.m_46597_(pos, rustable.getPrevious(state).get());
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult grassFlinting(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == Items.f_42484_ && CommonConfigs.GRASS_FLINTING.get().booleanValue()) {
            if (state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50599_) || state.m_60713_(ModBlocks.HUMUS.get()) || state.m_60713_(ModBlocks.FLUVISOL.get())) {
                level.m_5594_(player, pos, SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    level.m_46597_(pos, Blocks.f_50493_.m_49966_());
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                }
                return InteractionResult.SUCCESS;
            }
            if (state.m_60713_(Blocks.f_50493_)) {
                level.m_5594_(player, pos, SoundEvents.f_11996_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    level.m_46597_(pos, Blocks.f_50546_.m_49966_());
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult spawnAsh(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item instanceof ShovelItem && CommonConfigs.ASH_ITEM_SPAWN.get().booleanValue()) {
            if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue())) {
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModBlocks.SOOT.get()));
            }
            return InteractionResult.PASS;
        }
        if (item == Items.f_42410_) {
            if (state.m_60734_() instanceof MulchBlock) {
                level.m_5594_(player, pos, ModSoundEvents.YUMMY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult slimePistons(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == Items.f_42518_ && CommonConfigs.PISTON_SLIMING.get().booleanValue() && state.m_60713_(Blocks.f_50039_) && !((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
            if (level.f_46443_) {
                level.m_5594_(player, pos, SoundEvents.f_12388_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123753_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            } else {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_46597_(pos, Blocks.f_50032_.m_152465_(state));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.PASS;
        }
        if (item == Items.f_42574_ && CommonConfigs.PISTON_SLIMING.get().booleanValue() && state.m_60713_(Blocks.f_50032_) && !((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
            if (level.f_46443_) {
                level.m_5594_(player, pos, SoundEvents.f_12388_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123753_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            } else {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                level.m_46597_(pos, Blocks.f_50039_.m_152465_(state));
                if (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)Items.f_42518_.m_7968_());
                }
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult shearShearing(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item instanceof ShearsItem) {
            BlockState newState = null;
            if (CommonConfigs.AZALEA_SHEARING.get().booleanValue() && (newState = (BlockState)WeatheringHelper.getAzaleaSheared(state).orElse(null)) != null) {
                if (level.f_46443_) {
                    ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.AZALEA_FLOWER.get()), (UniformInt)UniformInt.m_146622_((int)4, (int)6));
                } else {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    if (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                        Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)new ItemStack((ItemLike)ModItems.AZALEA_FLOWERS.get()));
                    }
                }
            }
            if (newState == null && CommonConfigs.MOSS_SHEARING.get().booleanValue()) {
                newState = Mossable.getUnaffectedMossBlock(state);
                if (newState != state) {
                    if (IntegrationHandler.quark) {
                        newState = QuarkPlugin.fixVerticalSlab(newState, state);
                    }
                    if (level.f_46443_) {
                        ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.MOSS.get()), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                    } else {
                        CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                        if (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                            Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)new ItemStack((ItemLike)ModItems.MOSS_CLUMP.get()));
                        }
                    }
                } else {
                    newState = null;
                }
            }
            if (newState != null) {
                level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, newState);
                stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult burnMoss(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockState newBlock;
        if (item instanceof FlintAndSteelItem && CommonConfigs.MOSS_BURNING.get().booleanValue() && (newBlock = Mossable.getUnaffectedMossBlock(state)) != null) {
            newBlock = Weatherable.setStable(newBlock);
            if (level.f_46443_) {
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123744_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_46597_(pos, newBlock);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult pickaxeCracking(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item instanceof PickaxeItem && CommonConfigs.PICKAXE_CRACKING.get().booleanValue()) {
            if (!player.m_36341_() && CommonConfigs.PICKAXE_CRACKING_SHIFT.get().booleanValue()) {
                return InteractionResult.PASS;
            }
            BlockState newBlock = Crackable.getCrackedBlock(state);
            if (newBlock != state) {
                if (IntegrationHandler.quark) {
                    newBlock = QuarkPlugin.fixVerticalSlab(newBlock, state);
                }
                if (level.f_46443_) {
                    ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
                    level.m_5594_(player, pos, newBlock.m_60827_().m_56778_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    Block block = state.m_60734_();
                    if (block instanceof Crackable) {
                        Crackable crackable = (Crackable)block;
                        stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        level.m_46597_(pos, newBlock);
                        if (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                            Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)crackable.getRepairItem(state).m_7968_());
                        }
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult brickRepair(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockState newBlock;
        Crackable crackable;
        Block block = state.m_60734_();
        if (block instanceof Crackable && (crackable = (Crackable)block).getRepairItem(state) == item && state.m_204336_(ModTags.CRACKED) && (newBlock = Crackable.getUncrackedCrackBlock(state)) != null) {
            newBlock = Weatherable.setStable(newBlock);
            if (IntegrationHandler.quark) {
                newBlock = QuarkPlugin.fixVerticalSlab(newBlock, state);
            }
            if (level.f_46443_) {
                level.m_5594_(player, pos, newBlock.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_46597_(pos, newBlock);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult axeStripping(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        Item bark;
        if (item instanceof AxeItem && CommonConfigs.AXE_STRIPPING.get().booleanValue() && (bark = WeatheringHelper.getBarkToStrip(state)) != null) {
            if (level.f_46443_) {
                level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleOptions barkParticle = WeatheringHelper.getBarkParticle(state).orElse((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state));
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)barkParticle, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            } else {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                if (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)bark.m_7968_());
                }
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult barkRepairing(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        Pair fixedLog = WeatheringHelper.getBarkForStrippedLog(state).orElse(null);
        if (fixedLog != null && stack.m_41720_() == fixedLog.getFirst()) {
            BlockState newBlock = ((Block)fixedLog.getSecond()).m_152465_(state);
            if (IntegrationHandler.quark) {
                newBlock = QuarkPlugin.fixVerticalSlab(newBlock, state);
            }
            if (level.f_46443_) {
                level.m_5594_(player, pos, newBlock.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_46597_(pos, newBlock);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    static {
        EVENTS.add(ModEvents::slimePistons);
        EVENTS.add(ModEvents::pickaxeCracking);
        EVENTS.add(ModEvents::brickRepair);
        EVENTS.add(ModEvents::burnMoss);
        EVENTS.add(ModEvents::shearShearing);
        EVENTS.add(ModEvents::spawnAsh);
        EVENTS.add(ModEvents::grassFlinting);
        EVENTS.add(ModEvents::axeStripping);
        EVENTS.add(ModEvents::barkRepairing);
        EVENTS.add(ModEvents::rustScraping);
        EVENTS.add(ModEvents::rustSponging);
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public InteractionResult run(Item var1, ItemStack var2, BlockPos var3, BlockState var4, Player var5, Level var6, InteractionHand var7, BlockHitResult var8);
    }
}

