/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.ordana.immersive_weathering.blocks.MossMultifaceBlock;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.GlowLichenConfiguration;

public class MossFeature
extends Feature<GlowLichenConfiguration> {
    public MossFeature(Codec<GlowLichenConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GlowLichenConfiguration> context) {
        WorldGenLevel structureWorldAccess = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        Random random = context.m_159776_();
        GlowLichenConfiguration glowLichenFeatureConfig = (GlowLichenConfiguration)context.m_159778_();
        if (MossFeature.isAirOrWater(structureWorldAccess.m_8055_(blockPos))) {
            return false;
        }
        List<Direction> list = MossFeature.shuffleDirections(glowLichenFeatureConfig, random);
        if (MossFeature.generate(structureWorldAccess, blockPos, structureWorldAccess.m_8055_(blockPos), glowLichenFeatureConfig, random, list)) {
            return true;
        }
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        block0: for (Direction direction : list) {
            mutable.m_122190_((Vec3i)blockPos);
            List<Direction> list2 = MossFeature.shuffleDirections(glowLichenFeatureConfig, random, direction.m_122424_());
            for (int i = 0; i < glowLichenFeatureConfig.f_160870_; ++i) {
                mutable.m_122159_((Vec3i)blockPos, direction);
                BlockState blockState = structureWorldAccess.m_8055_((BlockPos)mutable);
                if (MossFeature.isAirOrWater(blockState) && !blockState.m_60713_(ModBlocks.MOSS.get())) continue block0;
                if (!MossFeature.generate(structureWorldAccess, (BlockPos)mutable, blockState, glowLichenFeatureConfig, random, list2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean generate(WorldGenLevel world, BlockPos pos, BlockState state, GlowLichenConfiguration config, Random random, List<Direction> directions) {
        Direction direction;
        BlockState blockState;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        Iterator<Direction> var7 = directions.iterator();
        do {
            if (var7.hasNext()) continue;
            return false;
        } while (!(blockState = world.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction = var7.next()))).m_204341_(config.f_160875_));
        MossMultifaceBlock mossBlock = (MossMultifaceBlock)ModBlocks.MOSS.get();
        BlockState blockState2 = mossBlock.m_153940_(state, (BlockGetter)world, pos, direction);
        if (blockState2 == null) {
            return false;
        }
        world.m_7731_(pos, blockState2, 3);
        world.m_46865_(pos).m_8113_(pos);
        if (random.nextFloat() < config.f_160874_) {
            mossBlock.m_153873_(blockState2, (LevelAccessor)world, pos, direction, random, true);
        }
        return true;
    }

    public static List<Direction> shuffleDirections(GlowLichenConfiguration config, Random random) {
        ArrayList list = Lists.newArrayList((Iterable)config.f_160876_);
        Collections.shuffle(list, random);
        return list;
    }

    public static List<Direction> shuffleDirections(GlowLichenConfiguration config, Random random, Direction excluded) {
        List<Direction> list = config.f_160876_.stream().filter(direction -> direction != excluded).collect(Collectors.toList());
        Collections.shuffle(list, random);
        return list;
    }

    private static boolean isAirOrWater(BlockState state) {
        return !state.m_60795_() && !state.m_60713_(Blocks.f_49990_);
    }
}

