/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.jetbrains.annotations.NotNull;

public class FeatureHacks {
    public static final Supplier<Feature<?>> VANILLA_JSON_FEATURE = RegHelper.registerFeature(ImmersiveWeathering.res("vanilla_json"), () -> new VanillaJsonFeature(VanillaJsonFeature.VanillaJsonFeatureConfig.CODEC));
    public static final Map<String, FeatureContainer> FEATURE_PLACERS = new HashMap<String, FeatureContainer>();
    private static final Map<ResourceKey<?>, TagKey<?>> FEATURES_PER_BIOME;
    private static final Map<TagKey<Biome>, List<String>> BUILTIN_TAGS;
    public static Supplier<PlacementModifierType<HardcodedBiomeFilter>> TYPE;

    public static void init() {
    }

    @NotNull
    private static void add(String n) {
        FEATURE_PLACERS.put(n, FeatureContainer.vanillaJsonFeature(ImmersiveWeathering.res(n)));
    }

    public static void registerVanillaBiomeFeatures(BiomeLoadingEvent ev, TagKey<Biome> biomeTagKey, ResourceKey<PlacedFeature> resourceKey, GenerationStep.Decoration step) {
        if (ev.getName() == null) {
            return;
        }
        FEATURES_PER_BIOME.put(resourceKey, biomeTagKey);
        if (FeatureHacks.isTagged(biomeTagKey, ev.getName())) {
            BiomeGenerationSettingsBuilder builder = ev.getGeneration();
            FeatureContainer f = FEATURE_PLACERS.get(resourceKey.m_135782_().m_135815_());
            if (f != null) {
                builder.m_204201_(step, Holder.m_205709_((Object)((PlacedFeature)f.placedFeature().get())));
            }
        }
    }

    public static boolean isTagged(TagKey<Biome> tag, ResourceLocation biome) {
        List<String> l = BUILTIN_TAGS.get(tag);
        if (l == null) {
            boolean a = true;
            return false;
        }
        return l.contains(biome.toString());
    }

    static {
        FeatureHacks.add("icicles");
        FeatureHacks.add("frost_patch");
        FeatureHacks.add("cryosol_patch");
        FeatureHacks.add("humus_patch");
        FeatureHacks.add("rooted_ceiling");
        FeatureHacks.add("fluvisol_patch_submerged");
        FeatureHacks.add("fluvisol_patch_surface");
        FeatureHacks.add("fluvisol_patch_dry");
        FeatureHacks.add("silt_disk");
        FeatureHacks.add("dry_lakebed");
        FeatureHacks.add("dry_lakebed_large");
        FeatureHacks.add("sandstone_blobs");
        FeatureHacks.add("sand_patch");
        FeatureHacks.add("sandy_clay_patch");
        FeatureHacks.add("sand_pile");
        FeatureHacks.add("desert_fossil");
        FeatureHacks.add("terracotta_blobs");
        FeatureHacks.add("vertisol_patch");
        FeatureHacks.add("ivy_patch");
        FeatureHacks.add("moss_patch");
        FEATURES_PER_BIOME = new HashMap();
        BUILTIN_TAGS = ImmutableMap.of(ModTags.HAS_FLUVISOL, (Object)ImmutableList.of((Object)"minecraft:swamp", (Object)"minecraft:river"), ModTags.HAS_HUMUS, (Object)ImmutableList.of((Object)"minecraft:dark_forest"), ModTags.HAS_IVY, (Object)ImmutableList.of((Object)"minecraft:forest", (Object)"minecraft:windswept_forest", (Object)"minecraft:flower_forest", (Object)"minecraft:dark_forest", (Object)"minecraft:birch_forest", (Object)"minecraft:old_growth_birch_forest"), ModTags.HAS_LAKEBED, (Object)ImmutableList.of((Object)"minecraft:badlands", (Object)"minecraft:eroded_badlands", (Object)"minecraft:wooded_badlands", (Object)"minecraft:desert"), ModTags.HAS_VERITOSOL, (Object)ImmutableList.of((Object)"minecraft:badlands", (Object)"minecraft:eroded_badlands", (Object)"minecraft:wooded_badlands"), ModTags.HOT, (Object)ImmutableList.of((Object)"minecraft:badlands", (Object)"minecraft:wooded_badlands", (Object)"minecraft:eroded_badlands", (Object)"minecraft:savanna", (Object)"minecraft:windswept_savanna", (Object)"minecraft:savanna_plateau", (Object)"minecraft:desert"), ModTags.ICY, (Object)ImmutableList.of((Object)"minecraft:ice_spikes", (Object)"minecraft:frozen_peaks", (Object)"minecraft:jagged_peaks", (Object)"minecraft:snowy_slopes", (Object)"minecraft:snowy_plains", (Object)"minecraft:snowy_taiga", (Object)"minecraft:frozen_ocean", (Object)"minecraft:deep_frozen_ocean", (Object)"minecraft:frozen_river"), ModTags.WET, (Object)ImmutableList.of((Object)"minecraft:swamp", (Object)"minecraft:jungle", (Object)"minecraft:sparse_jungle"), ModTags.UNDERGROUND_DESERT, (Object)ImmutableList.of((Object)"minecraft:desert"), ModTags.HAS_MOSS, (Object)ImmutableList.of((Object)"minecraft:lush_caves"));
        TYPE = RegHelper.register(ImmersiveWeathering.res("biome_tag"), () -> () -> HardcodedBiomeFilter.CODEC, Registry.f_194570_);
    }

    public record FeatureContainer(Supplier<? extends Feature<? extends FeatureConfiguration>> feature, NonNullLazy<ConfiguredFeature<? extends FeatureConfiguration, ? extends Feature<? extends FeatureConfiguration>>> configuredFeature, NonNullLazy<PlacedFeature> placedFeature) {
        static FeatureContainer vanillaJsonFeature(ResourceLocation placedFeatureId) {
            NonNullLazy configuredFeature = NonNullLazy.of(() -> new ConfiguredFeature(VANILLA_JSON_FEATURE.get(), (FeatureConfiguration)new VanillaJsonFeature.VanillaJsonFeatureConfig((ResourceKey<PlacedFeature>)ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)placedFeatureId))));
            return new FeatureContainer(VANILLA_JSON_FEATURE, (NonNullLazy<ConfiguredFeature<? extends FeatureConfiguration, ? extends Feature<? extends FeatureConfiguration>>>)configuredFeature, (NonNullLazy<PlacedFeature>)NonNullLazy.of(() -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)configuredFeature.get())), List.of())));
        }
    }

    public static class HardcodedBiomeFilter
    extends PlacementFilter {
        private final TagKey<Biome> tag;
        public static final Codec<HardcodedBiomeFilter> CODEC = RecordCodecBuilder.create(i -> i.group((App)TagKey.m_203877_((ResourceKey)Registry.f_122885_).fieldOf("tag").forGetter(e -> e.tag)).apply((Applicative)i, HardcodedBiomeFilter::new));

        private HardcodedBiomeFilter(TagKey<Biome> tag) {
            this.tag = tag;
            if (BuiltinRegistries.f_123865_.m_203431_(tag).isEmpty()) {
                // empty if block
            }
        }

        protected boolean m_183168_(PlacementContext context, Random random, BlockPos pos) {
            Holder holder = context.m_191831_().m_204166_(pos);
            return holder.m_203656_(this.tag);
        }

        public PlacementModifierType<?> m_183327_() {
            return TYPE.get();
        }
    }

    public static class VanillaJsonFeature
    extends Feature<VanillaJsonFeatureConfig> {
        public VanillaJsonFeature(Codec<VanillaJsonFeatureConfig> codec) {
            super(codec);
        }

        public boolean m_142674_(FeaturePlaceContext<VanillaJsonFeatureConfig> context) {
            WorldGenLevel level = context.m_159774_();
            return ((PlacedFeature)level.m_5962_().m_175515_(Registry.f_194567_).m_6246_(((VanillaJsonFeatureConfig)context.m_159778_()).feature())).m_191782_(level, context.m_159775_(), context.m_159776_(), context.m_159777_());
        }

        public record VanillaJsonFeatureConfig(ResourceKey<PlacedFeature> feature) implements FeatureConfiguration
        {
            public static final Codec<VanillaJsonFeatureConfig> CODEC = ResourceKey.m_195966_((ResourceKey)Registry.f_194567_).xmap(VanillaJsonFeatureConfig::new, VanillaJsonFeatureConfig::feature).fieldOf("feature").codec();
        }
    }
}

