/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.reg;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModParticles;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LeafPilesRegistry {
    public static final Supplier<Map<Block, LeafPileBlock>> LEAF_PILES = Suppliers.memoize(() -> {
        Map<Block, LeafPileBlock> piles = IWPlatformStuff.getDynamicLeafPiles();
        return Objects.requireNonNullElseGet(piles, () -> ImmutableMap.builder().put((Object)Blocks.f_50050_, (Object)ModBlocks.OAK_LEAF_PILE.get()).put((Object)Blocks.f_50055_, (Object)ModBlocks.DARK_OAK_LEAF_PILE.get()).put((Object)Blocks.f_50051_, (Object)ModBlocks.SPRUCE_LEAF_PILE.get()).put((Object)Blocks.f_50052_, (Object)ModBlocks.BIRCH_LEAF_PILE.get()).put((Object)Blocks.f_50053_, (Object)ModBlocks.JUNGLE_LEAF_PILE.get()).put((Object)Blocks.f_50054_, (Object)ModBlocks.ACACIA_LEAF_PILE.get()).put((Object)Blocks.f_152470_, (Object)ModBlocks.AZALEA_LEAF_PILE.get()).put((Object)Blocks.f_152471_, (Object)ModBlocks.FLOWERING_AZALEA_LEAF_PILE.get()).build());
    });
    public static final Supplier<Map<Block, Pair<Item, Block>>> STRIPPED_LOG_TO_BARK = Suppliers.memoize(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)Blocks.f_50010_, (Object)Pair.of((Object)ModItems.OAK_BARK.get(), (Object)Blocks.f_49999_)).put((Object)Blocks.f_50044_, (Object)Pair.of((Object)ModItems.OAK_BARK.get(), (Object)Blocks.f_50011_)).put((Object)Blocks.f_50006_, (Object)Pair.of((Object)ModItems.BIRCH_BARK.get(), (Object)Blocks.f_50001_)).put((Object)Blocks.f_50046_, (Object)Pair.of((Object)ModItems.BIRCH_BARK.get(), (Object)Blocks.f_50013_)).put((Object)Blocks.f_50005_, (Object)Pair.of((Object)ModItems.SPRUCE_BARK.get(), (Object)Blocks.f_50000_)).put((Object)Blocks.f_50045_, (Object)Pair.of((Object)ModItems.SPRUCE_BARK.get(), (Object)Blocks.f_50012_)).put((Object)Blocks.f_50007_, (Object)Pair.of((Object)ModItems.JUNGLE_BARK.get(), (Object)Blocks.f_50002_)).put((Object)Blocks.f_50047_, (Object)Pair.of((Object)ModItems.JUNGLE_BARK.get(), (Object)Blocks.f_50014_)).put((Object)Blocks.f_50009_, (Object)Pair.of((Object)ModItems.DARK_OAK_BARK.get(), (Object)Blocks.f_50004_)).put((Object)Blocks.f_50049_, (Object)Pair.of((Object)ModItems.DARK_OAK_BARK.get(), (Object)Blocks.f_50163_)).put((Object)Blocks.f_50008_, (Object)Pair.of((Object)ModItems.ACACIA_BARK.get(), (Object)Blocks.f_50003_)).put((Object)Blocks.f_50048_, (Object)Pair.of((Object)ModItems.ACACIA_BARK.get(), (Object)Blocks.f_50015_)).put((Object)Blocks.f_50696_, (Object)Pair.of((Object)ModItems.CRIMSON_SCALES.get(), (Object)Blocks.f_50695_)).put((Object)Blocks.f_50698_, (Object)Pair.of((Object)ModItems.CRIMSON_SCALES.get(), (Object)Blocks.f_50697_)).put((Object)Blocks.f_50687_, (Object)Pair.of((Object)ModItems.WARPED_SCALES.get(), (Object)Blocks.f_50686_)).put((Object)Blocks.f_50689_, (Object)Pair.of((Object)ModItems.WARPED_SCALES.get(), (Object)Blocks.f_50688_));
        IWPlatformStuff.addExtraBark((ImmutableMap.Builder<Block, Pair<Item, Block>>)builder);
        return builder.build();
    });
    public static final Supplier<Map<Block, SimpleParticleType>> LEAVES_TO_PARTICLE = Suppliers.memoize(() -> {
        Map<Block, SimpleParticleType> piles = IWPlatformStuff.getDynamicLeafParticles();
        return Objects.requireNonNullElseGet(piles, () -> ImmutableMap.builder().put((Object)Blocks.f_50050_, (Object)ModParticles.OAK_LEAF.get()).put((Object)Blocks.f_50055_, (Object)ModParticles.DARK_OAK_LEAF.get()).put((Object)Blocks.f_50051_, (Object)ModParticles.SPRUCE_LEAF.get()).put((Object)Blocks.f_50052_, (Object)ModParticles.BIRCH_LEAF.get()).put((Object)Blocks.f_50053_, (Object)ModParticles.JUNGLE_LEAF.get()).put((Object)Blocks.f_50054_, (Object)ModParticles.ACACIA_LEAF.get()).put((Object)Blocks.f_152470_, (Object)ModParticles.AZALEA_LEAF.get()).put((Object)Blocks.f_152471_, (Object)ModParticles.AZALEA_FLOWER.get()).build());
    });

    public static Optional<Block> getFallenLeafPile(BlockState state) {
        Block b = state.m_60734_();
        if (CommonConfigs.LEAF_PILES_BLACKLIST.get().contains(Registry.f_122824_.m_7981_((Object)b).toString())) {
            return Optional.empty();
        }
        return Optional.ofNullable((Block)LEAF_PILES.get().get(b));
    }

    public static Optional<SimpleParticleType> getFallenLeafParticle(BlockState state) {
        Block b = state.m_60734_();
        return Optional.ofNullable(LEAVES_TO_PARTICLE.get().get(b));
    }
}

