/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import java.util.Random;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public interface ILightable {
    public static final TagKey<Item> FLINT_AND_STEELS = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("forge", "tools/flint_and_steel"));

    public boolean isLit(BlockState var1);

    public BlockState toggleLitState(BlockState var1, boolean var2);

    default public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, FireSound sound) {
        if (!this.isLit(state)) {
            if (!world.m_5776_()) {
                world.m_7731_(pos, this.toggleLitState(state, true), 3);
                sound.play(world, pos);
            }
            world.m_142346_(player, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    default public boolean extinguish(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world) {
        if (this.isLit(state)) {
            if (!world.m_5776_()) {
                world.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
                world.m_7731_(pos, this.toggleLitState(state, false), 3);
            } else {
                Random random = world.m_5822_();
                for (int i = 0; i < 10; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.m_123342_() + 0.35f + random.nextFloat() * 0.5f), (double)((float)pos.m_123343_() + 0.25f + random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
                }
            }
            world.m_142346_(player, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    default public boolean interactWithProjectile(Level level, BlockState state, Projectile projectile, BlockPos pos) {
        ThrownPotion potion;
        if (projectile.m_6060_()) {
            Entity entity = projectile.m_37282_();
            if ((entity == null || entity instanceof Player || PlatformHelper.isMobGriefingOn(level, entity)) && this.lightUp((Entity)projectile, state, pos, (LevelAccessor)level, FireSound.FLAMING_ARROW)) {
                return true;
            }
        } else if (projectile instanceof ThrownPotion && PotionUtils.m_43579_((ItemStack)(potion = (ThrownPotion)projectile).m_7846_()) == Potions.f_43599_) {
            boolean flag;
            Entity entity = projectile.m_37282_();
            boolean bl = flag = entity == null || entity instanceof Player || PlatformHelper.isMobGriefingOn(level, entity);
            if (flag && this.extinguish((Entity)projectile, state, pos, (LevelAccessor)level)) {
                return true;
            }
        }
        return false;
    }

    default public InteractionResult interactWithPlayer(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (!this.isLit(state) && player.m_150110_().f_35938_) {
            ItemStack stack = player.m_21120_(handIn);
            Item item = stack.m_41720_();
            if (item instanceof FlintAndSteelItem || stack.m_204117_(FLINT_AND_STEELS)) {
                if (this.lightUp((Entity)player, state, pos, (LevelAccessor)worldIn, FireSound.FLINT_AND_STEEL)) {
                    stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }
            } else if (item instanceof FireChargeItem && this.lightUp((Entity)player, state, pos, (LevelAccessor)worldIn, FireSound.FIRE_CHANGE)) {
                stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public static enum FireSound {
        FLINT_AND_STEEL,
        FIRE_CHANGE,
        FLAMING_ARROW;


        public void play(LevelAccessor world, BlockPos pos) {
            switch (this) {
                case FIRE_CHANGE: {
                    world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (world.m_5822_().nextFloat() - world.m_5822_().nextFloat()) * 0.2f + 1.0f);
                    break;
                }
                case FLAMING_ARROW: {
                    world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 0.5f, 1.4f);
                    break;
                }
                case FLINT_AND_STEEL: {
                    world.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, world.m_5822_().nextFloat() * 0.4f + 0.8f);
                }
            }
        }
    }
}

