/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSBuriableConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class BuriableStructure<C extends RSBuriableConfig>
extends AbstractBaseStructure<C> {
    public BuriableStructure(Codec<C> codec) {
        super(codec, BuriableStructure::isFeatureChunk, BuriableStructure::generatePieces);
    }

    protected static <CC extends RSBuriableConfig> boolean isFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        RSBuriableConfig config = (RSBuriableConfig)context.f_197356_();
        if (config.cannotSpawnInWater) {
            BlockPos cornerOfSpawnChunk = context.f_197355_().m_45615_();
            int landHeight = context.f_197352_().m_156179_(cornerOfSpawnChunk.m_123341_(), cornerOfSpawnChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(cornerOfSpawnChunk.m_123341_(), cornerOfSpawnChunk.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(cornerOfSpawnChunk.m_123342_() + landHeight);
            return topBlock.m_60819_().m_76178_();
        }
        return true;
    }

    public static <CC extends RSBuriableConfig> Optional<PieceGenerator<CC>> generatePieces(PieceGeneratorSupplier.Context<CC> context) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), context.f_197352_().m_6337_(), context.f_197355_().m_45605_());
        RSBuriableConfig config = (RSBuriableConfig)context.f_197356_();
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            Heightmap.Types heightMapToUse = config.useOceanHeightmap ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
            BoundingBox box = ((PoolElementStructurePiece)pieces.get(0)).m_73547_();
            int highestLandPos = context.f_197352_().m_156179_(box.m_162395_(), box.m_162398_(), heightMapToUse, context.f_197357_());
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_156179_(box.m_162395_(), box.m_162401_(), heightMapToUse, context.f_197357_()));
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_156179_(box.m_162399_(), box.m_162398_(), heightMapToUse, context.f_197357_()));
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_156179_(box.m_162399_(), box.m_162401_(), heightMapToUse, context.f_197357_()));
            if (config.useOceanHeightmap) {
                int maxHeightForSubmerging = context.f_197352_().m_6337_() - box.m_71057_();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            }
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            int heightDiff = highestLandPos - box.m_162396_();
            for (StructurePiece structurePiece : pieces) {
                structurePiece.m_6324_(0, heightDiff + config.offsetAmount, 0);
            }
        });
    }
}

