/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMansionConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionStructurePiece;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.material.Material;

public class MansionStructure<C extends RSMansionConfig>
extends AbstractBaseStructure<C> {
    public MansionStructure(Codec<C> codec) {
        super(codec, MansionStructure::isMansionFeatureChunk, MansionStructure::generateMansionPieces, MansionStructure::afterPlace);
    }

    protected static <CC extends RSMansionConfig> boolean isMansionFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        ChunkPos chunkPos = context.f_197355_();
        RSMansionConfig config = (RSMansionConfig)context.f_197356_();
        if (!(context.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            for (int curChunkX = chunkPos.f_45578_ - config.biomeRadius; curChunkX <= chunkPos.f_45578_ + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - config.biomeRadius; curChunkZ <= chunkPos.f_45579_ + config.biomeRadius; ++curChunkZ) {
                    int yValue = context.f_197352_().m_156174_(curChunkX << 4, curChunkZ << 4, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    Holder biome = context.f_197353_().m_203407_(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.f_197352_().m_183403_());
                    if (context.f_197358_().test(biome)) continue;
                    return false;
                }
            }
        }
        for (ResourceKey<StructureSet> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.f_197352_().m_212265_(structureSetToAvoid, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, config.structureAvoidRadius)) continue;
            return false;
        }
        return true;
    }

    public static <CC extends RSMansionConfig> Optional<PieceGenerator<CC>> generateMansionPieces(PieceGeneratorSupplier.Context<CC> context) {
        RSMansionConfig config = (RSMansionConfig)context.f_197356_();
        ChunkPos chunkPos = context.f_197355_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        Rotation blockRotation = Rotation.m_55956_((Random)random);
        int xOffset = 5;
        int zOffset = 5;
        if (blockRotation == Rotation.CLOCKWISE_90) {
            xOffset = -5;
        } else if (blockRotation == Rotation.CLOCKWISE_180) {
            xOffset = -5;
            zOffset = -5;
        } else if (blockRotation == Rotation.COUNTERCLOCKWISE_90) {
            zOffset = -5;
        }
        int centerX = chunkPos.m_151390_();
        int centerZ = chunkPos.m_151393_();
        int firstHeight = context.f_197352_().m_156179_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int secondHeight = context.f_197352_().m_156179_(centerX, centerZ + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int thirdHeight = context.f_197352_().m_156179_(centerX + xOffset, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int forthheight = context.f_197352_().m_156179_(centerX + xOffset, centerZ + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int finalheight = Math.min(Math.min(firstHeight, secondHeight), Math.min(thirdHeight, forthheight));
        if (finalheight <= context.f_197352_().m_142062_()) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, contextx) -> {
            BlockPos blockPos = new BlockPos(chunkPos.m_151390_(), finalheight + 1, chunkPos.m_151393_());
            ArrayList<StructurePiece> list = new ArrayList<StructurePiece>();
            MansionPieces.createMansionLayout(context.f_197360_(), context.f_197359_(), blockPos, blockRotation, list, (Random)random, (RSMansionConfig)context.f_197356_());
            list.forEach(piece -> {
                if (piece instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece poolElementStructurePiece = (PoolElementStructurePiece)piece;
                    structurePiecesBuilder.m_142679_((StructurePiece)new MansionStructurePiece(poolElementStructurePiece, config.mansionType, config.foundationBlock, config.pillarOnlyToLand));
                } else {
                    structurePiecesBuilder.m_142679_(piece);
                }
            });
        });
    }

    private static void afterPlace(WorldGenLevel level, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        Object e;
        if (!piecesContainer.m_192748_() && (e = piecesContainer.f_192741_().get(0)) instanceof MansionStructurePiece) {
            MansionStructurePiece mansionStructurePiece = (MansionStructurePiece)((Object)e);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BoundingBox box = piecesContainer.m_192756_();
            int structureBottomY = box.m_162396_();
            int terrainY = Integer.MIN_VALUE;
            for (int x = box.m_162395_(); x <= box.m_162399_(); ++x) {
                block1: for (int z = box.m_162398_(); z <= box.m_162401_(); ++z) {
                    if (chunkPos.f_45578_ != x >> 4 || chunkPos.f_45579_ != z >> 4) continue;
                    mutableBlockPos.m_122178_(x, structureBottomY, z);
                    if (mansionStructurePiece.pillarOnlyToLand && (terrainY = GeneralUtils.getFirstLandYFromPos((LevelReader)level, mutableBlockPos.m_7495_())) <= chunkGenerator.m_142062_() || level.m_46859_((BlockPos)mutableBlockPos) || !box.m_71051_((Vec3i)mutableBlockPos) || !piecesContainer.m_192751_((BlockPos)mutableBlockPos)) continue;
                    for (int currentY = structureBottomY - 1; !(currentY <= chunkGenerator.m_142062_() || mansionStructurePiece.pillarOnlyToLand && currentY <= terrainY); --currentY) {
                        BlockPos blockPos2 = new BlockPos(x, currentY, z);
                        Material material = level.m_8055_(blockPos2).m_60767_();
                        if (!level.m_46859_(blockPos2) && !material.m_76332_() && material != Material.f_76302_ && material != Material.f_76303_ && material != Material.f_76304_) continue block1;
                        level.m_7731_(blockPos2, mansionStructurePiece.foundationBlock, 2);
                    }
                }
            }
        }
    }
}

