/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.config.QualityMode;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements DynamicLightSource {
    @Shadow
    public Level f_19853_;
    @Shadow
    private ChunkPos f_185933_;
    @Unique
    protected int lambdynlights$luminance = 0;
    @Unique
    private int lambdynlights$lastLuminance = 0;
    @Unique
    private long lambdynlights$lastUpdate = 0L;
    @Unique
    private double lambdynlights$prevX;
    @Unique
    private double lambdynlights$prevY;
    @Unique
    private double lambdynlights$prevZ;
    @Unique
    private LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();
    private static long lambdynlights_lastUpdate = 0L;

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20188_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract boolean m_6060_();

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Shadow
    public abstract boolean m_146910_();

    @Shadow
    public abstract BlockPos m_142538_();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.f_19853_.m_5776_()) {
            if (this.m_146910_()) {
                this.tdv$setDynamicLightEnabled(false);
            } else {
                this.tdv$dynamicLightTick();
                if (!((Boolean)DynamicLightsConfig.TileEntityLighting.get()).booleanValue() && this.m_6095_() != EntityType.f_20532_ || !DynamicLightHandlers.canLightUp((Entity)this)) {
                    this.lambdynlights$luminance = 0;
                }
                LambDynLights.updateTracking(this);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    public void onRemove(CallbackInfo ci) {
        if (this.f_19853_.m_5776_()) {
            this.tdv$setDynamicLightEnabled(false);
        }
    }

    @Override
    public double tdv$getDynamicLightX() {
        return this.m_20185_();
    }

    @Override
    public double tdv$getDynamicLightY() {
        return this.m_20188_();
    }

    @Override
    public double tdv$getDynamicLightZ() {
        return this.m_20189_();
    }

    @Override
    public Level tdv$getDynamicLightWorld() {
        return this.f_19853_;
    }

    @Override
    public void tdv$resetDynamicLight() {
        this.lambdynlights$lastLuminance = 0;
    }

    @Override
    public boolean tdv$shouldUpdateDynamicLight() {
        QualityMode mode = (QualityMode)((Object)DynamicLightsConfig.Quality.get());
        if (Objects.equals((Object)mode, (Object)QualityMode.OFF)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (Objects.equals((Object)mode, (Object)QualityMode.SLOW) && currentTime < lambdynlights_lastUpdate + 500L) {
            return false;
        }
        if (Objects.equals((Object)mode, (Object)QualityMode.FAST) && currentTime < lambdynlights_lastUpdate + 200L) {
            return false;
        }
        lambdynlights_lastUpdate = currentTime;
        return true;
    }

    @Override
    public void tdv$dynamicLightTick() {
        this.lambdynlights$luminance = this.m_6060_() ? 15 : 0;
        int luminance = DynamicLightHandlers.getLuminanceFrom((Entity)this);
        if (luminance > this.lambdynlights$luminance) {
            this.lambdynlights$luminance = luminance;
        }
    }

    @Override
    public int tdv$getLuminance() {
        return this.lambdynlights$luminance;
    }

    @Override
    public boolean tdv$lambdynlights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.tdv$shouldUpdateDynamicLight()) {
            return false;
        }
        double deltaX = this.m_20185_() - this.lambdynlights$prevX;
        double deltaY = this.m_20186_() - this.lambdynlights$prevY;
        double deltaZ = this.m_20189_() - this.lambdynlights$prevZ;
        int luminance = this.tdv$getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.lambdynlights$lastLuminance) {
            this.lambdynlights$prevX = this.m_20185_();
            this.lambdynlights$prevY = this.m_20186_();
            this.lambdynlights$prevZ = this.m_20189_();
            this.lambdynlights$lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                ChunkPos entityChunkPos = this.f_185933_;
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(entityChunkPos.f_45578_, SectionPos.m_175552_((double)this.m_20188_()), entityChunkPos.f_45579_);
                LambDynLights.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                LambDynLights.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                Direction directionX = (this.m_142538_().m_123341_() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (Mth.m_14080_((double)this.m_20188_()) & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.m_142538_().m_123343_() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.m_122173_(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.m_122173_(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.m_122173_(directionX.m_122424_());
                    } else {
                        chunkPos.m_122173_(directionZ.m_122424_());
                        chunkPos.m_122173_(directionY);
                    }
                    LambDynLights.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                    LambDynLights.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                }
            }
            this.tdv$lambdynlights$scheduleTrackedChunksRebuild(renderer);
            this.lambdynlights$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void tdv$lambdynlights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (Minecraft.m_91087_().f_91073_ == this.f_19853_) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

