/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements DynamicLightSource {
    @Unique
    protected int lambdynlights$luminance;
    @Unique
    private Level lambdynlights$lastWorld;

    @Shadow
    public abstract boolean m_5833_();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void tdv$dynamicLightTick() {
        if (!DynamicLightHandlers.canLightUp(this)) {
            this.lambdynlights$luminance = 0;
            return;
        }
        if (this.m_6060_() || this.m_142038_()) {
            this.lambdynlights$luminance = 15;
        } else {
            int luminance = DynamicLightHandlers.getLuminanceFrom(this);
            BlockPos eyePos = new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_());
            boolean submergedInFluid = !this.f_19853_.m_6425_(eyePos).m_76178_();
            for (ItemStack equipped : this.m_20158_()) {
                if (equipped.m_41619_()) continue;
                luminance = Math.max(luminance, LambDynLights.getLuminanceFromItemStack(equipped, submergedInFluid));
            }
            this.lambdynlights$luminance = luminance;
        }
        if (this.m_5833_()) {
            this.lambdynlights$luminance = 0;
        }
        if (this.lambdynlights$lastWorld != this.m_20193_()) {
            this.lambdynlights$lastWorld = this.m_20193_();
            this.lambdynlights$luminance = 0;
        }
    }

    @Override
    public int tdv$getLuminance() {
        return this.lambdynlights$luminance;
    }
}

