/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.logistics.block.display.AllDisplayBehaviours;
import com.simibubi.create.content.logistics.block.display.DisplayBehaviour;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.SingleLineDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.selene.fluids.ISoftFluidHolder;
import net.mehvahdjukaar.selene.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.HourGlassBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.ClockBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.HourGlassBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.util.TextHolder;
import net.mehvahdjukaar.supplementaries.common.items.BlackboardItem;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;

public class CreatePlugin {
    public static void initialize() {
        try {
            AllMovementBehaviours.registerBehaviour((Block)((Block)ModRegistry.BAMBOO_SPIKES.get()), (MovementBehaviour)new BambooSpikesBehavior());
            AllMovementBehaviours.registerBehaviour((Block)((Block)ModRegistry.HOURGLASS.get()), (MovementBehaviour)new HourglassBehavior());
            AllMovementBehaviours.registerBehaviour((Block)((Block)ModRegistry.PULLEY_BLOCK.get()), (MovementBehaviour)new PulleyBehavior());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("notice_board_display_target"), (DisplayBehaviour)new NoticeBoardDisplayTarget()), (BlockEntityType)((BlockEntityType)ModRegistry.NOTICE_BOARD_TILE.get()));
            DisplayBehaviour textHolderTarget = AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("text_holder_display_target"), (DisplayBehaviour)new TextHolderDisplayTarget());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, (BlockEntityType)((BlockEntityType)ModRegistry.SIGN_POST_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, (BlockEntityType)((BlockEntityType)ModRegistry.HANGING_SIGN_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, (BlockEntityType)((BlockEntityType)ModRegistry.DOORMAT_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, (BlockEntityType)((BlockEntityType)ModRegistry.DOORMAT_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("speaker_block_display_target"), (DisplayBehaviour)new SpeakerBlockDisplayTarget()), (BlockEntityType)((BlockEntityType)ModRegistry.SPEAKER_BLOCK_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("blackboard_display_target"), (DisplayBehaviour)new BlackboardDisplayTarget()), (BlockEntityType)((BlockEntityType)ModRegistry.BLACKBOARD_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("globe_display_target"), (DisplayBehaviour)new GlobeDisplaySource()), (BlockEntityType)((BlockEntityType)ModRegistry.GLOBE_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("clock_target"), (DisplayBehaviour)new ClockDisplaySource()), (BlockEntityType)((BlockEntityType)ModRegistry.CLOCK_BLOCK_TILE.get()));
            DisplayBehaviour itemDisplaySource = AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("item_display_target"), (DisplayBehaviour)new ItemDisplayDisplaySource());
            AllDisplayBehaviours.assignBlock((DisplayBehaviour)itemDisplaySource, (Block)((Block)ModRegistry.PEDESTAL.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)itemDisplaySource, (BlockEntityType)((BlockEntityType)ModRegistry.ITEM_SHELF_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)itemDisplaySource, (BlockEntityType)((BlockEntityType)ModRegistry.STATUE_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)itemDisplaySource, (BlockEntityType)((BlockEntityType)ModRegistry.HOURGLASS_TILE.get()));
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("fluid_tank_target"), (DisplayBehaviour)new FluidFillLevelDisplaySource()), (BlockEntityType)((BlockEntityType)ModRegistry.JAR_TILE.get()));
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to register supplementaries create behaviors: " + e);
        }
    }

    private static void changeState(MovementContext context, BlockState newState) {
        Map blocks = context.contraption.getBlocks();
        if (blocks.containsKey(context.localPos)) {
            context.state = newState;
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)blocks.get(context.localPos);
            StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(info.f_74675_, newState, info.f_74677_);
            blocks.replace(context.localPos, newInfo);
        }
    }

    private static Rotation isClockWise(UnaryOperator<Vec3> rot, Direction dir) {
        Vec3 v = MthUtils.V3itoV3((Vec3i)dir.m_122436_());
        Vec3 v2 = (Vec3)rot.apply(v);
        double dot = v2.m_82526_(new Vec3(0.0, 1.0, 0.0));
        if (dot > 0.0) {
            return Rotation.CLOCKWISE_90;
        }
        if (dot < 0.0) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    private static class BambooSpikesBehavior
    implements MovementBehaviour {
        private static final BambooSpikesBlockTile DUMMY = new BambooSpikesBlockTile(BlockPos.f_121853_, ((Block)ModRegistry.BAMBOO_SPIKES.get()).m_49966_());

        private BambooSpikesBehavior() {
        }

        public boolean isSameDir(MovementContext context) {
            return VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)BambooSpikesBlock.FACING)));
        }

        public boolean renderAsNormalTileEntity() {
            return true;
        }

        public void tick(MovementContext context) {
            this.damageEntities(context);
        }

        public void damageEntities(MovementContext context) {
            Level world = context.world;
            Vec3 pos = context.position;
            DamageSource damageSource = this.getDamageSource();
            block0: for (Entity entity2 : world.m_45976_(Entity.class, new AABB(pos.m_82520_(-0.5, -0.5, -0.5), pos.m_82520_(0.5, 0.5, 0.5)))) {
                Player player;
                if (entity2 instanceof ItemEntity || entity2 instanceof AbstractContraptionEntity || entity2 instanceof Player && (player = (Player)entity2).m_7500_()) continue;
                if (entity2 instanceof AbstractMinecart) {
                    for (Entity passenger : entity2.m_146897_()) {
                        AbstractContraptionEntity ace;
                        if (!(passenger instanceof AbstractContraptionEntity) || (ace = (AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                        continue block0;
                    }
                }
                if (entity2.m_6084_() && entity2 instanceof LivingEntity && !world.f_46443_) {
                    double pow = 5.0 * Math.pow(context.relativeMotion.m_82553_(), 0.4) + 1.0;
                    float damage = !this.isSameDir(context) ? 1.0f : (float)Mth.m_14008_((double)pow, (double)2.0, (double)6.0);
                    entity2.m_6469_(damageSource, damage);
                    this.doTileStuff(context, world, (LivingEntity)entity2);
                }
                if (world.f_46443_ != entity2 instanceof Player) continue;
                Vec3 motionBoost = context.motion.m_82520_(0.0, context.motion.m_82553_() / 4.0, 0.0);
                int maxBoost = 4;
                if (motionBoost.m_82553_() > (double)maxBoost) {
                    motionBoost = motionBoost.m_82546_(motionBoost.m_82541_().m_82490_(motionBoost.m_82553_() - (double)maxBoost));
                }
                entity2.m_20256_(entity2.m_20184_().m_82549_(motionBoost));
                entity2.f_19864_ = true;
            }
        }

        private void doTileStuff(MovementContext context, @Nonnull Level world, LivingEntity le) {
            CompoundTag com = context.tileData;
            long lastTicked = com.m_128454_("LastTicked");
            if (!this.isOnCooldown(world, lastTicked)) {
                DUMMY.m_142466_(com);
                if (DUMMY.interactWithEntity(le, world)) {
                    CreatePlugin.changeState(context, (BlockState)context.state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                com = DUMMY.m_187480_();
                lastTicked = world.m_46467_();
                com.m_128356_("LastTicked", lastTicked);
                context.tileData = com;
            }
        }

        public boolean isOnCooldown(Level world, long lastTicked) {
            return world.m_46467_() - lastTicked < 20L;
        }

        protected DamageSource getDamageSource() {
            return CommonUtil.SPIKE_DAMAGE;
        }
    }

    private static class HourglassBehavior
    implements MovementBehaviour {
        private HourglassBehavior() {
        }

        public void tick(MovementContext context) {
            UnaryOperator rot = context.rotation;
            BlockState state = context.state;
            Direction dir = (Direction)state.m_61143_((Property)HourGlassBlock.FACING);
            Rotation rotation = CreatePlugin.isClockWise(rot, dir);
            CompoundTag com = context.tileData;
            HourGlassBlockTile.HourGlassSandType sandType = HourGlassBlockTile.HourGlassSandType.values()[com.m_128451_("SandType")];
            float progress = com.m_128457_("Progress");
            float prevProgress = com.m_128457_("PrevProgress");
            if (!sandType.isEmpty()) {
                prevProgress = progress;
                if (rotation == Rotation.CLOCKWISE_90 && progress != 1.0f) {
                    progress = Math.min(progress + sandType.increment, 1.0f);
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90 && progress != 0.0f) {
                    progress = Math.max(progress - sandType.increment, 0.0f);
                }
            }
            com.m_128473_("Progress");
            com.m_128473_("PrevProgress");
            com.m_128350_("Progress", progress);
            com.m_128350_("PrevProgress", prevProgress);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
            CompoundTag com = context.tileData;
            HourGlassBlockTile.HourGlassSandType sandType = HourGlassBlockTile.HourGlassSandType.values()[com.m_128451_("SandType")];
            float progress = com.m_128457_("Progress");
            float prevProgress = com.m_128457_("PrevProgress");
            NonNullList stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)com, (NonNullList)stacks);
            float partialTicks = 1.0f;
            if (sandType.isEmpty()) {
                return;
            }
            Vec3 v = context.position;
            if (v == null) {
                v = new Vec3(0.0, 0.0, 0.0);
            }
            BlockPos pos = new BlockPos(v);
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)context.world, (BlockPos)pos);
            TextureAtlasSprite sprite = sandType.getSprite((ItemStack)stacks.get(0), (Level)renderWorld);
            float h = Mth.m_14179_((float)partialTicks, (float)prevProgress, (float)progress);
            Direction dir = (Direction)context.state.m_61143_((Property)HourGlassBlock.FACING);
            HourGlassBlockTileRenderer.renderSand(matrices.getModelViewProjection(), buffer, light, 0, sprite, h, dir);
        }
    }

    private static class PulleyBehavior
    implements MovementBehaviour {
        private static final PulleyBlockTile DUMMY = new PulleyBlockTile(BlockPos.f_121853_, ((Block)ModRegistry.PULLEY_BLOCK.get()).m_49966_());

        private PulleyBehavior() {
        }

        public void visitNewPosition(MovementContext context, BlockPos pos) {
            BlockState state = context.state;
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)PulleyBlock.f_55923_);
            if (axis == Direction.Axis.Y) {
                return;
            }
            CreatePlugin.changeState(context, (BlockState)state.m_61122_((Property)PulleyBlock.FLIPPED));
            Direction dir = null;
            BlockPos center = context.contraption.anchor;
            if (axis == Direction.Axis.X) {
                dir = Direction.NORTH;
            } else if (axis == Direction.Axis.Z) {
                dir = Direction.WEST;
            }
            if (dir == null) {
                return;
            }
            DUMMY.m_142466_(context.tileData);
            DUMMY.m_142339_(context.world);
            Rotation rot = context.relativeMotion.m_82553_() > 0.0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
            DUMMY.handleRotation(rot);
            context.tileData = DUMMY.m_187480_();
        }
    }

    private static class NoticeBoardDisplayTarget
    extends DisplayTarget {
        private NoticeBoardDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            NoticeBoardBlockTile lectern;
            ItemStack book;
            BlockEntity te = context.getTargetTE();
            if (te instanceof NoticeBoardBlockTile && !(book = (lectern = (NoticeBoardBlockTile)te).getDisplayedItem()).m_41619_()) {
                if (book.m_150930_(Items.f_42614_)) {
                    book = this.signBook(book);
                    lectern.setDisplayedItem(book);
                }
                if (book.m_150930_(Items.f_42615_)) {
                    ListTag tag = book.m_41783_().m_128437_("pages", 8);
                    boolean changed = false;
                    for (int i = 0; i - line < text.size() && i < 50; ++i) {
                        if (tag.size() <= i) {
                            tag.add((Object)StringTag.m_129297_((String)(i < line ? "" : Component.Serializer.m_130703_((Component)((Component)text.get(i - line))))));
                        } else if (i >= line) {
                            if (i - line == 0) {
                                NoticeBoardDisplayTarget.reserve((int)i, (BlockEntity)lectern, (DisplayLinkContext)context);
                            }
                            if (i - line > 0 && this.isReserved(i - line, (BlockEntity)lectern, context)) break;
                            tag.set(i, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)((Component)text.get(i - line)))));
                        }
                        changed = true;
                    }
                    book.m_41783_().m_128365_("pages", (Tag)tag);
                    lectern.setDisplayedItem(book);
                    if (changed) {
                        context.level().m_7260_(context.getTargetPos(), lectern.m_58900_(), lectern.m_58900_(), 2);
                    }
                }
            }
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            return new DisplayTargetStats(50, 256, (DisplayTarget)this);
        }

        public Component getLineOptionText(int line) {
            return Lang.translateDirect((String)"display_target.page", (Object[])new Object[]{line + 1});
        }

        private ItemStack signBook(ItemStack book) {
            ItemStack written = new ItemStack((ItemLike)Items.f_42615_);
            CompoundTag compoundtag = book.m_41783_();
            if (compoundtag != null) {
                written.m_41751_(compoundtag.m_6426_());
            }
            written.m_41700_("author", (Tag)StringTag.m_129297_((String)"Data Gatherer"));
            written.m_41700_("filtered_title", (Tag)StringTag.m_129297_((String)"Printed Book"));
            written.m_41700_("title", (Tag)StringTag.m_129297_((String)"Printed Book"));
            return written;
        }
    }

    private static class TextHolderDisplayTarget
    extends DisplayTarget {
        private TextHolderDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            BlockEntity te = context.getTargetTE();
            if (te instanceof ITextHolderProvider) {
                ITextHolderProvider th = (ITextHolderProvider)te;
                TextHolder textHolder = th.getTextHolder();
                boolean changed = false;
                for (int i = 0; i < text.size() && i + line < textHolder.size(); ++i) {
                    if (i == 0) {
                        TextHolderDisplayTarget.reserve((int)(i + line), (BlockEntity)te, (DisplayLinkContext)context);
                    }
                    if (i > 0 && this.isReserved(i + line, te, context)) break;
                    textHolder.setLine(i + line, (Component)text.get(i));
                    changed = true;
                }
                if (changed) {
                    context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                }
            }
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            TextHolder textHolder = ((ITextHolderProvider)context.getTargetTE()).getTextHolder();
            return new DisplayTargetStats(textHolder.size(), 20, (DisplayTarget)this);
        }
    }

    private static class SpeakerBlockDisplayTarget
    extends DisplayTarget {
        private SpeakerBlockDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            BlockEntity te = context.getTargetTE();
            if (te instanceof SpeakerBlockTile) {
                SpeakerBlockTile tile = (SpeakerBlockTile)te;
                if (text.size() > 0) {
                    SpeakerBlockDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
                    tile.message = text.get(0).getString();
                    context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                }
            }
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            return new DisplayTargetStats(1, 32, (DisplayTarget)this);
        }
    }

    private static class BlackboardDisplayTarget
    extends DisplayTarget {
        private BlackboardDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            BlockEntity te = context.getTargetTE();
            if (te instanceof BlackboardBlockTile) {
                BlackboardBlockTile tile = (BlackboardBlockTile)te;
                if (text.size() > 0 && !tile.isWaxed()) {
                    ItemDisplayTile display;
                    ItemStack stack;
                    BlockEntity source = context.getSourceTE();
                    if (source instanceof ItemDisplayTile && BlackboardDisplayTarget.copyBlackboard(line, context, te, tile, stack = (display = (ItemDisplayTile)source).getDisplayedItem())) {
                        return;
                    }
                    for (int i = 0; i < 32; ++i) {
                        BlockPos pos = context.getSourcePos();
                        TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)TileEntityBehaviour.get((BlockGetter)context.level(), (BlockPos)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
                        if (behaviour == null) break;
                        MutableObject stackHolder = new MutableObject();
                        behaviour.handleCenteredProcessingOnAllItems(0.25f, tis -> {
                            stackHolder.setValue((Object)tis.stack);
                            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                        });
                        ItemStack stack2 = (ItemStack)stackHolder.getValue();
                        if (stack2 == null || !(stack2.m_41720_() instanceof BlackboardItem) || !BlackboardDisplayTarget.copyBlackboard(line, context, te, tile, stack2)) continue;
                        return;
                    }
                    long[] pixels = BlackboardBlockTile.unpackPixelsFromString(text.get(0).getString());
                    tile.setPixels(BlackboardBlockTile.unpackPixels(pixels));
                    context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                    BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
                }
            }
        }

        private static boolean copyBlackboard(int line, DisplayLinkContext context, BlockEntity te, BlackboardBlockTile tile, ItemStack stack) {
            CompoundTag cmp;
            if (stack.m_41720_() instanceof BlackboardItem && (cmp = stack.m_41737_("BlockEntityTag")) != null && cmp.m_128441_("Pixels")) {
                tile.setPixels(BlackboardBlockTile.unpackPixels(cmp.m_128467_("Pixels")));
                context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
                return true;
            }
            return false;
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            return new DisplayTargetStats(1, 32, (DisplayTarget)this);
        }
    }

    private static class GlobeDisplaySource
    extends SingleLineDisplaySource {
        public static final MutableComponent EMPTY = Components.literal((String)"--,--");

        private GlobeDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            BlockEntity blockEntity = context.getSourceTE();
            if (blockEntity instanceof GlobeBlockTile) {
                GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
                BlockPos pos = context.getSourcePos();
                return new TextComponent("X: " + pos.m_123341_() + ", Z: " + pos.m_123343_());
            }
            return EMPTY;
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }

        protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
            return "Instant";
        }

        protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
            return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
        }

        protected String getTranslationKey() {
            return "world_position";
        }
    }

    private static class ClockDisplaySource
    extends SingleLineDisplaySource {
        public static final MutableComponent EMPTY_TIME = Components.literal((String)"--:--");

        private ClockDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            Level level = context.level();
            if (level instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                BlockEntity blockEntity = context.getSourceTE();
                if (blockEntity instanceof ClockBlockTile) {
                    ClockBlockTile tile = (ClockBlockTile)blockEntity;
                    boolean c12 = context.sourceConfig().m_128451_("Cycle") == 0;
                    boolean isNatural = sLevel.m_6042_().m_63956_();
                    int dayTime = (int)(sLevel.m_46468_() % 24000L);
                    int hours = (dayTime / 1000 + 6) % 24;
                    int minutes = dayTime % 1000 * 60 / 1000;
                    MutableComponent suffix = Lang.translateDirect((String)("generic.daytime." + (hours > 11 ? "pm" : "am")), (Object[])new Object[0]);
                    minutes = minutes / 5 * 5;
                    if (c12 && (hours %= 12) == 0) {
                        hours = 12;
                    }
                    if (!isNatural) {
                        hours = Create.RANDOM.nextInt(70) + 24;
                        minutes = Create.RANDOM.nextInt(40) + 60;
                    }
                    MutableComponent component = Components.literal((String)((hours < 10 ? " " : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + (c12 ? " " : "")));
                    return c12 ? component.m_7220_((Component)suffix) : component;
                }
            }
            return EMPTY_TIME;
        }

        protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
            return "Instant";
        }

        protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
            return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
        }

        protected String getTranslationKey() {
            return "time_of_day";
        }

        @OnlyIn(value=Dist.CLIENT)
        public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
            super.initConfigurationWidgets(context, builder, isFirstLine);
            if (!isFirstLine) {
                builder.addSelectionScrollInput(0, 60, (si, l) -> si.forOptions(Lang.translatedOptions((String)"display_source.time", (String[])new String[]{"12_hour", "24_hour"})).titled(Lang.translateDirect((String)"display_source.time.format", (Object[])new Object[0])), "Cycle");
            }
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }
    }

    private static class ItemDisplayDisplaySource
    extends SingleLineDisplaySource {
        private ItemDisplayDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            ItemDisplayTile te;
            MutableComponent combined = EMPTY_LINE.m_6881_();
            BlockEntity blockEntity = context.getSourceTE();
            if (blockEntity instanceof ItemDisplayTile && !(te = (ItemDisplayTile)blockEntity).m_7983_()) {
                combined = combined.m_7220_(te.getDisplayedItem().m_41786_());
            }
            return combined;
        }

        public int getPassiveRefreshTicks() {
            return 20;
        }

        protected String getTranslationKey() {
            return "item_name";
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }

        protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
            return "Number";
        }
    }

    public static class FluidFillLevelDisplaySource
    extends PercentOrProgressBarDisplaySource {
        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            BlockEntity blockEntity;
            if (context.sourceConfig().m_128451_("Mode") == 2 && (blockEntity = context.getSourceTE()) instanceof ISoftFluidHolder) {
                ISoftFluidHolder tp = (ISoftFluidHolder)blockEntity;
                return Components.literal((String)(tp.getSoftFluidHolder().getCount() + " mBtl"));
            }
            return super.provideLine(context, stats);
        }

        protected Float getProgress(DisplayLinkContext context) {
            BlockEntity te = context.getSourceTE();
            if (te instanceof ISoftFluidHolder) {
                ISoftFluidHolder tp = (ISoftFluidHolder)te;
                return Float.valueOf(tp.getSoftFluidHolder().getHeight(1.0f));
            }
            return null;
        }

        protected boolean progressBarActive(DisplayLinkContext context) {
            return context.sourceConfig().m_128451_("Mode") == 1;
        }

        protected String getTranslationKey() {
            return "fluid_amount";
        }

        @OnlyIn(value=Dist.CLIENT)
        public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
            super.initConfigurationWidgets(context, builder, isFirstLine);
            if (!isFirstLine) {
                builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(Lang.translatedOptions((String)"display_source.fill_level", (String[])new String[]{"percent", "progress_bar", "fluid_amount"})).titled(Lang.translateDirect((String)"display_source.fill_level.display", (Object[])new Object[0])), "Mode");
            }
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }
    }
}

