/*
 * Decompiled with CFR 0.152.
 */
package ht.treeplant.server.config;

import ht.treeplant.server.config.PlantingConfig;
import ht.treeplant.server.event.AutoPlant;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static int numTicksToRetryPlanting;
    public static int numTicksBetweenTries;
    public static TagKey<Item> itemTagForSaplings;
    public static boolean allowPlantingWithRightClick;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void onLoad() {
        ConfigHandler.onReload();
        AutoPlant.init();
    }

    public static void onReload() {
        numTicksToRetryPlanting = Math.max(1, ConfigHandler.secondsToTicks((Double)ConfigHandler.COMMON.numSecondsToRetryPlanting.get()));
        numTicksBetweenTries = Math.max(1, ConfigHandler.secondsToTicks((Double)ConfigHandler.COMMON.numSecondsBetweenTries.get()));
        itemTagForSaplings = ItemTags.create((ResourceLocation)new ResourceLocation((String)ConfigHandler.COMMON.itemTagForPlantableItems.get()));
        allowPlantingWithRightClick = (Boolean)ConfigHandler.COMMON.allowPlantingWithRightClick.get();
        ConfigHandler.COMMON.naturalSaplings.refresh();
        ConfigHandler.COMMON.tossedSaplings.refresh();
        ConfigHandler.COMMON.brokenSaplings.refresh();
        ConfigHandler.COMMON.despawningSaplings.refresh();
    }

    public static int secondsToTicks(double seconds) {
        return (int)Math.ceil(seconds * 20.0);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        protected final ForgeConfigSpec.ConfigValue<String> itemTagForPlantableItems;
        protected final ForgeConfigSpec.DoubleValue numSecondsToRetryPlanting;
        protected final ForgeConfigSpec.DoubleValue numSecondsBetweenTries;
        protected final ForgeConfigSpec.BooleanValue allowPlantingWithRightClick;
        public final PlantingConfig naturalSaplings;
        public final PlantingConfig tossedSaplings;
        public final PlantingConfig brokenSaplings;
        public final PlantingConfig despawningSaplings;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("What to plant");
            this.itemTagForPlantableItems = builder.comment("Items with this tag will be automatically planted when possible").define("itemTagForPlantableItems", (Object)"treeplant:auto_plantables");
            builder.pop();
            builder.comment("Set chanceOfPlanting = 0.0 to disable").push("When to plant");
            this.naturalSaplings = new PlantingConfig(builder, "Saplings that fall naturally (e.g. when leaves decay or when using tree felling mods)", 1.0, 3.0, 1.0, 2);
            this.brokenSaplings = new PlantingConfig(builder, "Saplings that drop when a player breaks a block", 10.0, 3.0, 1.0, 1);
            this.tossedSaplings = new PlantingConfig(builder, "Saplings tossed by players", 5.0, 3.0, 0.0, 1);
            this.despawningSaplings = new PlantingConfig(builder, "Saplings that are about to despawn, no matter where they came from", null, null, 1.0, 2);
            builder.pop();
            builder.push("Miscellaneous");
            this.numSecondsToRetryPlanting = builder.comment("The number of seconds to keep trying to plant a sapling after the first attempt").defineInRange("numSecondsToRetryPlanting", 120.0, 0.0, 100000.0);
            this.numSecondsBetweenTries = builder.comment("The number of seconds to wait before trying to plant after a failed attempt").defineInRange("numSecondsBetweenTries", 1.0, 0.0, 100000.0);
            this.allowPlantingWithRightClick = builder.comment("Whether to allow players to plant saplings by right-clicking on dirt").define("allowRightClickPlanting", true);
            builder.pop();
        }
    }
}

