/*
 * Decompiled with CFR 0.152.
 */
package ht.treeplant.server.util;

import ht.treeplant.server.config.ConfigHandler;
import ht.treeplant.server.config.PlantingConfig;
import ht.treeplant.server.event.AutoPlant;
import ht.treeplant.server.util.PlantUtil;
import ht.treeplant.server.util.RandomUtil;
import java.lang.ref.WeakReference;
import net.minecraft.world.entity.item.ItemEntity;

public class ItemEntityWatcher
implements Comparable<ItemEntityWatcher> {
    private long tick;
    private int totalNumTicks = 0;
    private final long lastPossibleTick;
    private final WeakReference<ItemEntity> ref;
    private final PlantingConfig plantingConfig;

    public ItemEntityWatcher(ItemEntity itemEntity, long tickZero, PlantingConfig plantingConfig) {
        this.ref = new WeakReference<ItemEntity>(itemEntity);
        this.tick = tickZero + (long)plantingConfig.getNumTicksBeforePlanting() + (long)((int)RandomUtil.get(plantingConfig.getWiggle()));
        this.lastPossibleTick = this.tick + (long)ConfigHandler.numTicksToRetryPlanting;
        this.plantingConfig = plantingConfig;
    }

    public long getTick() {
        return this.tick;
    }

    public void activate() {
        boolean successful;
        ItemEntity itemEntity = (ItemEntity)this.ref.get();
        if (itemEntity != null && itemEntity.m_6084_() && PlantUtil.noNearbySaplings(itemEntity, this.plantingConfig) && (successful = PlantUtil.tryToPlant(itemEntity))) {
            this.totalNumTicks = (int)((long)this.totalNumTicks + this.tick);
            if ((long)this.totalNumTicks < this.lastPossibleTick) {
                this.tick += (long)ConfigHandler.numTicksBetweenTries;
                AutoPlant.watch(this);
            }
        }
    }

    @Override
    public int compareTo(ItemEntityWatcher other) {
        return Long.compare(this.tick, other.tick);
    }
}

