/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states;
    private final Server voicechatServer;

    public PlayerStateManager(Server voicechatServer) {
        this.voicechatServer = voicechatServer;
        this.states = new ConcurrentHashMap();
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedIn(this::onPlayerLoggedIn);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::onPlayerLoggedOut);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatConnected(this::onPlayerVoicechatConnect);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatDisconnected(this::onPlayerVoicechatDisconnect);
        CommonCompatibilityManager.INSTANCE.onPlayerCompatibilityCheckSucceeded(this::onPlayerCompatibilityCheckSucceeded);
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.m_142081_());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisabled(packet.isDisabled());
            this.states.put(player.m_142081_(), state);
            this.broadcastState(state);
            Voicechat.logDebug("Got state of {}: {}", player.m_5446_().getString(), state);
        });
    }

    private void broadcastState(PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        this.voicechatServer.getServer().m_6846_().m_11314_().forEach(p -> NetManager.sendToClient(p, packet));
    }

    private void onPlayerCompatibilityCheckSucceeded(ServerPlayer player) {
        PlayerStatesPacket packet = new PlayerStatesPacket(this.states);
        NetManager.sendToClient(player, packet);
        Voicechat.logDebug("Sending initial states to {}", player.m_5446_().getString());
    }

    private void onPlayerLoggedIn(ServerPlayer player) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(player);
        this.states.put(player.m_142081_(), state);
        this.broadcastState(state);
        Voicechat.logDebug("Setting default state of {}: {}", player.m_5446_().getString(), state);
    }

    private void onPlayerLoggedOut(ServerPlayer player) {
        this.states.remove(player.m_142081_());
        this.broadcastState(new PlayerState(player.m_142081_(), player.m_36316_().getName(), false, true));
        Voicechat.logDebug("Removing state of {}", player.m_5446_().getString());
    }

    private void onPlayerVoicechatDisconnect(UUID uuid) {
        PlayerState state = this.states.get(uuid);
        if (state == null) {
            return;
        }
        state.setDisconnected(true);
        this.broadcastState(state);
        Voicechat.logDebug("Set state of {} to disconnected: {}", uuid, state);
    }

    private void onPlayerVoicechatConnect(ServerPlayer player) {
        PlayerState state = this.states.get(player.m_142081_());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisconnected(false);
        this.states.put(player.m_142081_(), state);
        this.broadcastState(state);
        Voicechat.logDebug("Set state of {} to connected: {}", player.m_5446_().getString(), state);
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(ServerPlayer player) {
        return new PlayerState(player.m_142081_(), player.m_36316_().getName(), false, true);
    }

    public void setGroup(ServerPlayer player, @Nullable ClientGroup group) {
        PlayerState state = this.states.get(player.m_142081_());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.logDebug("Defaulting to default state for {}: {}", player.m_5446_().getString(), state);
        }
        state.setGroup(group);
        this.states.put(player.m_142081_(), state);
        this.broadcastState(state);
        Voicechat.logDebug("Setting group of {}: {}", player.m_5446_().getString(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

